/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.operations.LoopExpOperations;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;

public class IterateExpOperations
extends LoopExpOperations {
    protected IterateExpOperations() {
    }

    public static <C, PM> boolean checkIterateType(IterateExp<C, PM> iterateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(iterateExp, context);
        Variable<C, PM> vd = iterateExp.getResult();
        Object type = iterateExp.getType();
        if (vd != null && type != null && vd.getType() != null && !TypeUtil.exactTypeMatch(env, type, vd.getType())) {
            result = false;
            message = OCLMessages.bind(OCLMessages.TypeConformanceIterateExp_ERROR_, iterateExp.toString());
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 14, message, new Object[]{iterateExp}));
        }
        return result;
    }

    public static <C, PM> boolean checkBodyType(IterateExp<C, PM> iterateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(iterateExp, context);
        Variable<C, PM> vd = iterateExp.getResult();
        OCLExpression body = iterateExp.getBody();
        if (vd != null && body != null && vd.getType() != null && body.getType() != null && !TypeUtil.compatibleTypeMatch(env, body.getType(), vd.getType())) {
            result = false;
            message = OCLMessages.bind(OCLMessages.TypeConformanceIterateExpBody_ERROR_, iterateExp.toString());
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 15, message, new Object[]{iterateExp}));
        }
        return result;
    }

    public static <C, PM> boolean checkResultInit(IterateExp<C, PM> iterateExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Variable<C, PM> vd = iterateExp.getResult();
        if (vd != null && vd.getInitExpression() == null) {
            result = false;
            message = OCLMessages.bind(OCLMessages.MissingInitIterateExp_ERROR_, iterateExp.toString());
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 16, message, new Object[]{iterateExp}));
        }
        return result;
    }
}

