/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.IExportFilter;
import org.eclipse.fordiac.ide.export.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.CMakeListsMarker;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractExporter {
    private final String outputDirectory;
    private final IConfigurationElement filterConfig;
    private boolean overwriteWithoutWarning;
    private boolean enableCMakeLists;
    private final IExportFilter filter;

    public void exportElements(IProgressMonitor monitor, List<IFile> exportees) {
        monitor.beginTask(MessageFormat.format(Messages.FordiacExporter_ExportingSelectedTypesUsingExporter, this.filterConfig.getAttribute("name")), exportees.size() + 1);
        if (this.filter != null) {
            for (IFile file : exportees) {
                if (this.exportIsCanceled(monitor)) continue;
                try {
                    this.exportElement(monitor, this.filter, file, null);
                }
                catch (ExportException.OverwriteAll e) {
                    this.overwriteWithoutWarning = true;
                }
                catch (ExportException.CancelAll e) {
                    this.enableCMakeLists = false;
                    this.filter.getWarnings().add(Messages.FordiacExporter_EXPORT_CANCELED);
                    break;
                }
                catch (ExportException.UserInteraction userInteraction) {
                    // empty catch block
                }
                monitor.worked(1);
            }
            if (this.enableCMakeLists && !monitor.isCanceled()) {
                try {
                    this.exportElement(monitor, this.filter, null, (EObject)new CMakeListsMarker(exportees.getFirst().getProject(), Path.of(this.outputDirectory, new String[0])));
                }
                catch (ExportException.UserInteraction userInteraction) {
                    // empty catch block
                }
                monitor.worked(1);
            }
            monitor.worked(1);
            if (this.exportIsCanceled(monitor)) {
                this.filter.getErrors().add(Messages.FordiacExporter_EXPORT_CANCELED);
                throw new OperationCanceledException();
            }
            Display.getDefault().asyncExec(() -> this.showErrorWarningSummary(this.filter));
        }
        monitor.done();
    }

    protected AbstractExporter(IConfigurationElement filterConfig, String outputDirectory, boolean overwriteWithoutWarning, boolean enableCMakeLists) {
        this.filterConfig = filterConfig;
        this.outputDirectory = outputDirectory;
        this.overwriteWithoutWarning = overwriteWithoutWarning;
        this.enableCMakeLists = enableCMakeLists;
        this.filter = this.createExportFilter();
    }

    protected boolean exportIsCanceled(IProgressMonitor monitor) {
        return monitor.isCanceled();
    }

    protected void exportElement(IProgressMonitor monitor, IExportFilter filter, IFile file, EObject source) throws ExportException.UserInteraction {
        try {
            if (source instanceof CMakeListsMarker) {
                monitor.subTask(Messages.FordiacExporter_ExportingCMakeLists);
                filter.export(null, this.outputDirectory, this.overwriteWithoutWarning, source);
            } else {
                monitor.subTask(MessageFormat.format(Messages.FordiacExporter_ExportingType, AbstractExporter.getExportElementName(source, file)));
                filter.export(file, this.outputDirectory, this.overwriteWithoutWarning, source);
            }
        }
        catch (ExportException.UserInteraction e) {
            throw e;
        }
        catch (ExportException e) {
            this.processError(Messages.FordiacExporter_ERROR + e.getMessage());
        }
    }

    protected IExportFilter createExportFilter() {
        IExportFilter exportFilter = null;
        try {
            exportFilter = (IExportFilter)this.filterConfig.createExecutableExtension("class");
        }
        catch (CoreException e) {
            this.processError(Messages.FordiacExporter_ERROR + e.getMessage());
        }
        return exportFilter;
    }

    protected abstract void showErrorWarningSummary(IExportFilter var1);

    protected abstract void processError(String var1);

    private static String getExportElementName(EObject element, IFile file) {
        String name = "anonymous";
        if (element instanceof INamedElement) {
            INamedElement ne = (INamedElement)element;
            name = ne.getName();
        } else if (file != null) {
            name = file.getFullPath().removeFileExtension().lastSegment();
        }
        return name;
    }
}

