/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.editor.internal.pages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sirius.ui.editor.Messages;
import org.eclipse.sirius.ui.editor.SessionEditorPlugin;
import org.eclipse.sirius.ui.editor.api.pages.PageProvider;
import org.eclipse.sirius.ui.editor.api.pages.PageProviderRegistry;

public class PluginPageProviderRegistry
implements IRegistryEventListener {
    public static final String PAGE_PROVIDER_EXTENSION_POINT_ID = "org.eclipse.sirius.ui.editor.sessionEditorPageProvider";
    private static final String PAGE_PROVIDER_ELEMENT_NAME = "pageProvider";
    private static final String PAGE_PROVIDER_CLASS_ATTRIBUTE_NAME = "class";
    private PageProviderRegistry pageRegistry;
    private Map<IExtension, List<PageProvider>> extensionToPageProvider;

    public PluginPageProviderRegistry(PageProviderRegistry thePageRegistry) {
        this.pageRegistry = thePageRegistry;
        this.extensionToPageProvider = new HashMap<IExtension, List<PageProvider>>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(PAGE_PROVIDER_EXTENSION_POINT_ID).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseExtension(extension);
            ++n2;
        }
    }

    private void parseExtension(IExtension extension) {
        IConfigurationElement[] configurationElements;
        List<PageProvider> pageProviders = this.extensionToPageProvider.get(extension);
        if (pageProviders == null) {
            pageProviders = new ArrayList<PageProvider>();
            this.extensionToPageProvider.put(extension, pageProviders);
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (PAGE_PROVIDER_ELEMENT_NAME.equals(configurationElement.getName())) {
                try {
                    Object newInstance = configurationElement.createExecutableExtension(PAGE_PROVIDER_CLASS_ATTRIBUTE_NAME);
                    if (PageProvider.class.isAssignableFrom(newInstance.getClass())) {
                        PageProvider pageProvider = (PageProvider)newInstance;
                        pageProviders.add(pageProvider);
                        this.pageRegistry.addPageProvider(pageProvider);
                    } else {
                        SessionEditorPlugin.getPlugin().error(MessageFormat.format(Messages.PluginPageProviderRegistry_badClassType, newInstance.getClass().getName()), null);
                    }
                }
                catch (CoreException e) {
                    SessionEditorPlugin.getPlugin().error(MessageFormat.format(Messages.PluginPageProviderRegistry_classInitialization, configurationElement.getName()), (Exception)((Object)e));
                }
            }
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            List<PageProvider> pageProviders = this.extensionToPageProvider.get(extension);
            if (pageProviders != null) {
                for (PageProvider pageProvider : pageProviders) {
                    this.pageRegistry.removePageProvider(pageProvider);
                }
            }
            this.extensionToPageProvider.put(extension, null);
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }
}

