/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer.IntegerDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.junit.Assert;
import org.junit.Test;

public class CTF2IntegrationTest {
    @Test
    public void testIntegerWithMappings() throws Exception {
        CTFTrace trace = new CTFTrace();
        JsonObject fieldClass = new JsonObject();
        fieldClass.add("type", (JsonElement)new JsonPrimitive("fixed-length-unsigned-integer"));
        fieldClass.add("length", (JsonElement)new JsonPrimitive((Number)8));
        fieldClass.add("byte-order", (JsonElement)new JsonPrimitive("le"));
        JsonObject mappings = new JsonObject();
        JsonArray range1 = new JsonArray();
        range1.add((JsonElement)new JsonPrimitive((Number)0));
        range1.add((JsonElement)new JsonPrimitive((Number)0));
        JsonArray ranges1 = new JsonArray();
        ranges1.add((JsonElement)range1);
        mappings.add("ZERO", (JsonElement)ranges1);
        JsonArray range2 = new JsonArray();
        range2.add((JsonElement)new JsonPrimitive((Number)1));
        range2.add((JsonElement)new JsonPrimitive((Number)1));
        JsonArray ranges2 = new JsonArray();
        ranges2.add((JsonElement)range2);
        mappings.add("ONE", (JsonElement)ranges2);
        fieldClass.add("mappings", (JsonElement)mappings);
        JsonStructureFieldMemberMetadataNode node = new JsonStructureFieldMemberMetadataNode(null, "fixed-length-unsigned-integer", "test", "int_field", fieldClass);
        IntegerDeclaration result = IntegerDeclarationParser.INSTANCE.parse((ICTFMetadataNode)node, (ICommonTreeParser.ICommonTreeParserParameter)new IntegerDeclarationParser.Param(trace));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)8L, (long)result.getLength());
        Assert.assertNotNull((Object)result.getMappings());
        Assert.assertEquals((long)2L, (long)result.getMappings().size());
        Assert.assertTrue((boolean)result.getMappings().containsKey("ZERO"));
        Assert.assertTrue((boolean)result.getMappings().containsKey("ONE"));
    }
}

