/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.filter;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTraceTypeNode;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtEventType;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlEventType;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlInputElement;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.tracecompass.tmf.core.tests.filter.TmfFilterTreeNodeTestBase;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfFilterTraceTypeNodeTest
extends TmfFilterTreeNodeTestBase {
    private static final String CATEGORY_TXT = "txt";
    private static final String CATEGORY_XML = "xml";
    private static final @NonNull String DEFINITION_NAME_TXT = "name txt";
    private static final @NonNull String DEFINITION_NAME_XML = "name xml";
    private static final String SEP = ":";
    private static final String CUSTOM_TXT_TRACE_TYPE_PREFIX = "custom.txt.trace:";
    private static final String CUSTOM_XML_TRACE_TYPE_PREFIX = "custom.xml.trace:";
    private static CustomTxtTraceDefinition fCustomTxtDefinition = new CustomTxtTraceDefinition();
    private static CustomXmlTraceDefinition fCustomXmlDefinition = new CustomXmlTraceDefinition();
    private static CustomTxtTrace fCustomTxtTrace;
    private static CustomXmlTrace fCustomXmlTrace;
    private static TmfEventType fCustomTxtEventType;
    private static TmfEventType fCustomXmlEventType;
    private ITmfEventField fContent = new TmfEventField(":root:", null, null);
    private TmfEvent fEvent1 = new TmfEvent(TRACE, 0L, TmfTimestamp.fromNanos((long)1L), EVENT_TYPE, this.fContent);
    private TmfEvent fEvent2 = new CustomTxtEvent(fCustomTxtDefinition, (ITmfTrace)fCustomTxtTrace, TmfTimestamp.fromNanos((long)2L), fCustomTxtEventType);
    private TmfEvent fEvent3 = new CustomXmlEvent(fCustomXmlDefinition, (ITmfTrace)fCustomXmlTrace, TmfTimestamp.fromNanos((long)3L), fCustomXmlEventType);
    private TmfFilterTraceTypeNode fFilter;

    static {
        TmfFilterTraceTypeNodeTest.fCustomTxtDefinition.categoryName = CATEGORY_TXT;
        TmfFilterTraceTypeNodeTest.fCustomTxtDefinition.definitionName = DEFINITION_NAME_TXT;
        TmfFilterTraceTypeNodeTest.fCustomXmlDefinition.categoryName = CATEGORY_XML;
        TmfFilterTraceTypeNodeTest.fCustomXmlDefinition.definitionName = DEFINITION_NAME_XML;
        TmfFilterTraceTypeNodeTest.fCustomXmlDefinition.rootInputElement = new CustomXmlInputElement();
        fCustomTxtTrace = new CustomTxtTrace(fCustomTxtDefinition);
        fCustomXmlTrace = new CustomXmlTrace(fCustomXmlDefinition);
        fCustomTxtEventType = new CustomTxtEventType(DEFINITION_NAME_TXT, null);
        fCustomXmlEventType = new CustomXmlEventType(DEFINITION_NAME_XML, null);
    }

    @AfterClass
    public static void disposeCustomTraces() {
        fCustomTxtTrace.dispose();
        fCustomXmlTrace.dispose();
    }

    @Before
    public void createFilter() {
        this.fFilter = new TmfFilterTraceTypeNode(null);
        this.fFilterNode = this.fFilter;
    }

    @Test
    public void testMatches() {
        this.fFilter.setTraceClass(TmfTraceStub.class);
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
        this.fFilter.setTraceClass(CustomTxtTrace.class);
        this.fFilter.setTraceTypeId("custom.txt.trace:txt:name txt");
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
        this.fFilter.setTraceClass(CustomXmlTrace.class);
        this.fFilter.setTraceTypeId("custom.xml.trace:xml:name xml");
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertTrue((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
        this.fFilter.setTraceClass(CustomTxtTrace.class);
        this.fFilter.setTraceTypeId("custom.txt.trace:xml:name xml");
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent1));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent2));
        Assert.assertFalse((boolean)this.fFilter.matches((ITmfEvent)this.fEvent3));
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((String)"getName()", (Object)"TRACETYPE", (Object)this.fFilter.getNodeName());
    }

    @Test
    public void testGetValidChildren() {
        HashSet<String> validChildren = new HashSet<String>(Arrays.asList("TRACETYPE", "AND", "OR", "CONTAINS", "EQUALS", "MATCHES", "COMPARE"));
        Assert.assertEquals((String)"getValidChildren()", validChildren, new HashSet(this.fFilter.getValidChildren()));
    }
}

