/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup.containers;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupMessages;

public abstract class CompositeSourceContainer
extends AbstractSourceContainer {
    private ISourceContainer[] fContainers;

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public Object[] findSourceElements(String name) throws CoreException {
        return this.findSourceElements(name, this.getSourceContainers());
    }

    protected Object[] findSourceElements(String name, ISourceContainer[] containers) throws CoreException {
        ArrayList results = null;
        CoreException single = null;
        MultiStatus multiStatus = null;
        if (this.isFindDuplicates()) {
            results = new ArrayList();
        }
        ISourceContainer[] iSourceContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                ISourceContainer container = iSourceContainerArray[n2];
                try {
                    Object[] objects = container.findSourceElements(name);
                    if (objects.length <= 0) break block11;
                    if (results != null) {
                        Collections.addAll(results, objects);
                        break block11;
                    }
                    if (objects.length == 1) {
                        return objects;
                    }
                    return new Object[]{objects[0]};
                }
                catch (CoreException e) {
                    if (single == null) {
                        single = e;
                    }
                    if (multiStatus == null) {
                        multiStatus = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 125, new IStatus[]{single.getStatus()}, SourceLookupMessages.Source_Lookup_Error, null);
                        multiStatus.add(e.getStatus());
                    }
                    multiStatus.add(e.getStatus());
                }
            }
            ++n2;
        }
        if (results == null) {
            if (multiStatus != null) {
                throw new CoreException(multiStatus);
            }
            if (single != null) {
                throw single;
            }
            return EMPTY;
        }
        return results.toArray();
    }

    protected abstract ISourceContainer[] createSourceContainers() throws CoreException;

    @Override
    public synchronized ISourceContainer[] getSourceContainers() throws CoreException {
        if (this.fContainers == null) {
            ISourceContainer[] iSourceContainerArray = this.fContainers = this.createSourceContainers();
            int n = this.fContainers.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer container = iSourceContainerArray[n2];
                container.init(this.getDirector());
                ++n2;
            }
        }
        return this.fContainers;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fContainers != null) {
            ISourceContainer[] iSourceContainerArray = this.fContainers;
            int n = this.fContainers.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer container = iSourceContainerArray[n2];
                container.dispose();
                ++n2;
            }
        }
        this.fContainers = null;
    }
}

