/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.handler;

import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValueModification;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.gef.dialogs.VariableDialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ChangeValuesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ChangeValuesHandler.changeValues(HandlerUtil.getActiveShell((ExecutionEvent)event), ChangeValuesHandler.getVariables(HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event)).toList());
        return null;
    }

    private static void changeValues(Shell shell, List<EvaluatorDebugVariable> variables) {
        List values = VariableDialog.open((Shell)shell, variables.stream().map(EvaluatorDebugVariable::getInternalVariable));
        if (!values.isEmpty()) {
            int i = 0;
            while (i < variables.size()) {
                try {
                    variables.get(i).setValue((String)values.get(i));
                }
                catch (DebugException e) {
                    ErrorDialog.openError(null, null, null, (IStatus)Status.error((String)e.getLocalizedMessage(), (Throwable)e));
                }
                ++i;
            }
        }
    }

    public void setEnabled(Object evaluationContext) {
        IStructuredSelection selection;
        Object object = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(object instanceof IStructuredSelection && ChangeValuesHandler.getVariables(selection = (IStructuredSelection)object).allMatch(IValueModification::supportsValueModification));
    }

    private static Stream<EvaluatorDebugVariable> getVariables(IStructuredSelection selection) {
        return selection.stream().filter(EvaluatorDebugVariable.class::isInstance).map(EvaluatorDebugVariable.class::cast);
    }
}

