/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.build;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Leaf;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.util.IResourceScopeCache;

public class HierarchyResourceDescription
extends DefaultResourceDescription {
    private final IQualifiedNameConverter nameConverter;
    private Iterable<QualifiedName> importedNames;

    public HierarchyResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy, IResourceScopeCache cache, IQualifiedNameConverter nameConverter) {
        super(resource, strategy, cache);
        this.nameConverter = nameConverter;
    }

    public Iterable<QualifiedName> getImportedNames() {
        if (this.importedNames == null) {
            this.importedNames = this.computeImportedNames();
        }
        return this.importedNames;
    }

    protected Set<QualifiedName> computeImportedNames() {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        TreeIterator allContents = EcoreUtil.getAllContents((Resource)this.getResource(), (boolean)true);
        while (allContents.hasNext()) {
            EObject target = (EObject)allContents.next();
            if (!(target instanceof Leaf)) continue;
            Leaf leaf = (Leaf)target;
            this.computeImportedNames(leaf, result);
        }
        super.getImportedNames().forEach(result::add);
        return result;
    }

    protected void computeImportedNames(Leaf leaf, Set<QualifiedName> result) {
        QualifiedName containerTypeName = this.getContainerTypeName(leaf.getContainerFileName());
        QualifiedName refName = this.nameConverter.toQualifiedName(leaf.getRef());
        result.add(containerTypeName.append(refName).toLowerCase());
    }

    protected QualifiedName getContainerTypeName(String containerFileName) {
        URI containerURI;
        TypeEntry typeEntry;
        Path containerPath = new Path(containerFileName);
        if (this.getURI().isPlatformResource() && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForURI(containerURI = this.getURI().trimSegments(this.getURI().segmentCount() - 2).appendSegments(containerPath.segments()))) != null) {
            return QualifiedName.create((String[])typeEntry.getFullTypeName().split("::"));
        }
        return QualifiedName.create((String)TypeEntry.getTypeNameFromFileName((String)containerPath.lastSegment()));
    }
}

