/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.edit.providers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.fordiac.ide.model.edit.providers.BoldStyler;
import org.eclipse.fordiac.ide.model.edit.providers.TypeImageProvider;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class ResultListLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private String[] searchString;
    private final boolean showFilePath;

    public ResultListLabelProvider() {
        this(false);
    }

    public ResultListLabelProvider(boolean showFilePath) {
        this.setSearchString("");
        this.showFilePath = showFilePath;
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof TypeEntry) {
            TypeEntry entry = (TypeEntry)element;
            StyledString styledString = ResultListLabelProvider.getTypeEntryStyledText(entry, this.showFilePath);
            int lastIndex = 0;
            String[] stringArray = this.searchString;
            int n = this.searchString.length;
            int n2 = 0;
            while (n2 < n) {
                String searchStringElement = stringArray[n2];
                int offset = styledString.toString().toUpperCase().indexOf(searchStringElement.toUpperCase(), lastIndex);
                if (offset >= 0) {
                    styledString.setStyle(offset, searchStringElement.length(), (StyledString.Styler)BoldStyler.INSTANCE_DEFAULT);
                    lastIndex = offset + searchStringElement.length();
                }
                ++n2;
            }
            return styledString;
        }
        if (element != null) {
            return new StyledString(element.toString());
        }
        return new StyledString();
    }

    public static StyledString getTypeEntryStyledText(TypeEntry entry, boolean showFilePath) {
        StyledString styledString = new StyledString(entry.getTypeName());
        String packageName = entry.getPackageName();
        if (!packageName.isEmpty()) {
            styledString.append(" - " + packageName, StyledString.DECORATIONS_STYLER);
        }
        if (showFilePath) {
            ResultListLabelProvider.addFilePath(styledString, entry.getFile(), packageName);
        }
        styledString.append(" [" + entry.getComment() + "]", showFilePath ? StyledString.DECORATIONS_STYLER : StyledString.QUALIFIER_STYLER);
        return styledString;
    }

    private static void addFilePath(StyledString styledString, IFile file, String packageName) {
        Object pathString;
        IPath filePath = file.getFullPath();
        String filePackageName = PackageNameHelper.getPackageNameFromFile((IFile)file);
        if (!packageName.isEmpty() && !filePackageName.isEmpty() && filePackageName.toLowerCase().endsWith(packageName.toLowerCase())) {
            int stripCount = packageName.split("::").length + 1;
            pathString = filePath.removeLastSegments(stripCount).addTrailingSeparator().toOSString() + "...";
        } else {
            pathString = filePath.removeLastSegments(1).toOSString();
        }
        styledString.append(" - " + (String)pathString, StyledString.QUALIFIER_STYLER);
    }

    public Image getImage(Object element) {
        if (element instanceof TypeEntry) {
            TypeEntry entry = (TypeEntry)element;
            return TypeImageProvider.getImageForTypeEntry(entry);
        }
        return null;
    }

    public String getText(Object element) {
        String string;
        if (element instanceof TypeEntry) {
            TypeEntry entry = (TypeEntry)element;
            string = String.format("%s - %s", this.getStyledText(element).toString(), entry.getFile().getFullPath());
        } else {
            string = "-";
        }
        return string;
    }

    public void setSearchString(String searchString) {
        this.searchString = new String[]{searchString};
        this.validateSearchString();
    }

    private void validateSearchString() {
        this.searchString = this.searchString[0].split("[\\*\\?]+", -1);
        int i = 0;
        while (i < this.searchString.length) {
            this.searchString[i] = this.searchString[i].replaceAll("\\W", "");
            ++i;
        }
    }
}

