/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public class LibraryElementContentProvider
extends AdapterFactoryContentProvider {
    protected List<Notifier> targets = new ArrayList<Notifier>();
    protected final Adapter typeEntryAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            Object feature = notification.getFeature();
            if ("TYPE_ENTRY_TYPE_FEATURE".equals(feature) || "TYPE_ENTRY_TYPE_EDITABLE_FEATURE".equals(feature)) {
                TypeEntry entry = (TypeEntry)notification.getNotifier();
                LibraryElementContentProvider.super.notifyChanged((Notification)new ViewerNotification(notification, (Object)entry.getFile()));
            }
        }
    };

    public LibraryElementContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile element = (IFile)parentElement;
            TypeEntry entry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(element);
            if (entry != null) {
                this.hookToTypeEntry(entry);
                return super.getChildren((Object)entry.getTypeEditable());
            }
            return new Object[0];
        }
        return super.getChildren(parentElement);
    }

    public Object getParent(Object object) {
        Object parent = super.getParent(object);
        if (parent instanceof LibraryElement) {
            LibraryElement libElement = (LibraryElement)parent;
            return libElement.getTypeEntry().getFile();
        }
        return parent;
    }

    protected void hookToTypeEntry(TypeEntry entry) {
        if (!entry.eAdapters().contains((Object)this.typeEntryAdapter)) {
            entry.eAdapters().add((Object)this.typeEntryAdapter);
            this.targets.add((Notifier)entry);
        }
    }

    public void dispose() {
        super.dispose();
        this.targets.forEach(entry -> {
            boolean bl = entry.eAdapters().remove((Object)this.typeEntryAdapter);
        });
        this.targets = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object instanceof LibraryElement) {
            LibraryElement libElement = (LibraryElement)object;
            super.notifyChanged((Notification)new ViewerNotification(notification, (Object)libElement.getTypeEntry().getFile()));
        } else {
            super.notifyChanged(notification);
        }
    }
}

