/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.connection;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.create.StructDataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.AbstractCommandChange;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class SystemConnectStructChange
extends AbstractCommandChange<AutomationSystem> {
    private final Map<String, String> replaceableConMap;
    private final String sourceVarName;
    private final String destinationVarName;
    private final List<URI> conlist;

    public SystemConnectStructChange(URI elementURI, List<URI> list, Map<String, String> replaceableConMap, String sourceVarName, String destinationVarName) {
        super(Objects.requireNonNull(elementURI).trimFileExtension().lastSegment() + Messages.SystemConnectStructChange_Name, elementURI, AutomationSystem.class);
        this.conlist = Objects.requireNonNull(list);
        this.replaceableConMap = Objects.requireNonNull(replaceableConMap);
        this.sourceVarName = Objects.requireNonNull(sourceVarName);
        this.destinationVarName = Objects.requireNonNull(destinationVarName);
    }

    @Override
    public void initializeValidationData(AutomationSystem element, IProgressMonitor pm) {
    }

    @Override
    public RefactoringStatus isValid(AutomationSystem element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        this.conlist.forEach(uri -> {
            if (!uri.toPlatformString(true).equals(this.getElementURI().toPlatformString(true))) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)(String.valueOf(uri) + Messages.ConnectionsToStructRefactoring_FBNotInSystem + String.valueOf(this.getElementURI()))));
            }
        });
        return status;
    }

    @Override
    protected Command createCommand(AutomationSystem element) {
        CompoundCommand cmds = new CompoundCommand();
        this.conlist.forEach(uri -> {
            EObject eObject = element.eResource().getEObject(uri.fragment());
            if (eObject instanceof BlockFBNetworkElement) {
                BlockFBNetworkElement fbnelem = (BlockFBNetworkElement)eObject;
                BlockFBNetworkElement source = fbnelem.getInterface().getErrorMarker().stream().flatMap(err -> err.getInputConnections().stream()).filter(con -> this.replaceableConMap.containsValue(con.getDestination().getName())).findFirst().get().getSourceElement();
                StructDataConnectionCreateCommand structCon = new StructDataConnectionCreateCommand(fbnelem.getFbNetwork());
                structCon.setDestination(fbnelem.getInput(this.destinationVarName));
                structCon.setSource(source.getOutput(this.sourceVarName));
                cmds.add((Command)structCon);
                fbnelem.getInterface().getErrorMarker().stream().flatMap(err -> err.getInputConnections().stream()).filter(con -> this.replaceableConMap.containsValue(con.getDestination().getName())).forEach(con -> cmds.add((Command)new DeleteConnectionCommand(con)));
            }
        });
        return cmds;
    }
}

