/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf3d;

import org.eclipse.amp.agf3d.IRenderer;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.shapes.CuboidShape;
import org.eclipse.draw3d.util.ColorConverter;
import org.eclipse.swt.graphics.Color;

public class RenderShape
extends CuboidShape {
    public static final int SCALE = 20;
    private static final float[] DEFAULT_COLOR = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private final float[] m_color = new float[]{DEFAULT_COLOR[0], DEFAULT_COLOR[1], DEFAULT_COLOR[2], DEFAULT_COLOR[3]};
    boolean update = true;
    IFigure3D figure;
    private final IRenderer renderer;
    private final Object object;

    public RenderShape(IFigure3D figure, IRenderer renderer, Object object) {
        super((IPosition3D)figure.getPosition3D(), false);
        this.figure = figure;
        this.renderer = renderer;
        this.object = object;
    }

    protected void doRender(RenderContext iRenderContext) {
        this.renderer.renderShape(this.figure, iRenderContext, this.object);
    }

    public String toString() {
        return "CuboidFigureShape [m_figure=" + this.figure + "]";
    }

    public void setColor(Color i_color, int i_alpha) {
        if (i_color == null) {
            throw new NullPointerException("i_color must not be null");
        }
        ColorConverter.toFloatArray((Color)i_color, (int)i_alpha, (float[])this.m_color);
    }

    public void setColor(int i_color, int i_alpha) {
        ColorConverter.toFloatArray((int)i_color, (int)i_alpha, (float[])this.m_color);
    }

    private void glSetColor(Graphics3D g3d) {
        float r = this.m_color[0];
        float g = this.m_color[1];
        float b = this.m_color[2];
        float a = this.m_color[3];
        g3d.glColor4f(r, g, b, a);
    }

    public void glSetColor(Graphics3D g3d, Color i_color) {
        this.setColor(i_color, 255);
        this.glSetColor(g3d);
    }

    public void glSetColor(Graphics3D g3d, Color i_color, int alpha) {
        this.setColor(i_color, alpha);
        this.glSetColor(g3d);
    }

    public Object getModel() {
        return this.object;
    }
}

