/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.gradleware.tooling.toolingclient.CompositeModelRequest;
import com.gradleware.tooling.toolingclient.CompositeRequest;
import com.gradleware.tooling.toolingclient.Consumer;
import com.gradleware.tooling.toolingclient.Request;
import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniEclipseWorkspace;
import com.gradleware.tooling.toolingmodel.repository.CompositeModelRepository;
import com.gradleware.tooling.toolingmodel.repository.EclipseWorkspaceUpdateEvent;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepositoryProvider;
import com.gradleware.tooling.toolingmodel.repository.SimpleModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.internal.BaseConverter;
import com.gradleware.tooling.toolingmodel.repository.internal.BaseModelRepository;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseWorkspace;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.util.GradleVersion;

public class DefaultCompositeModelRepository
extends BaseModelRepository
implements CompositeModelRepository {
    private final ModelRepositoryProvider modelRepositoryProvider;
    private final ImmutableSet<FixedRequestAttributes> requestAttributes;

    public DefaultCompositeModelRepository(ModelRepositoryProvider modelRepositoryProvider, Set<FixedRequestAttributes> requestAttributes, ToolingClient toolingClient, EventBus eventBus) {
        super(toolingClient, eventBus);
        this.modelRepositoryProvider = (ModelRepositoryProvider)Preconditions.checkNotNull((Object)modelRepositoryProvider);
        Preconditions.checkArgument((requestAttributes.size() > 0 ? 1 : 0) != 0, (Object)"Composite builds need at least one participant");
        this.requestAttributes = ImmutableSet.copyOf(requestAttributes);
    }

    @Override
    public OmniEclipseWorkspace fetchEclipseWorkspace(final TransientRequestAttributes transientAttributes, FetchStrategy fetchStrategy) {
        CompositeModelRequest<EclipseProject> modelRequest = this.createModelRequest((Class)EclipseProject.class, (Set<FixedRequestAttributes>)this.requestAttributes, transientAttributes);
        Consumer<OmniEclipseWorkspace> successHandler = new Consumer<OmniEclipseWorkspace>(){

            public void accept(OmniEclipseWorkspace result) {
                DefaultCompositeModelRepository.this.postEvent(new EclipseWorkspaceUpdateEvent(result));
            }
        };
        BaseConverter<Set<EclipseProject>, OmniEclipseWorkspace> converter = new BaseConverter<Set<EclipseProject>, OmniEclipseWorkspace>(){

            @Override
            public OmniEclipseWorkspace apply(Set<EclipseProject> eclipseProjects) {
                final HashMap knownProjects = Maps.newHashMap();
                ImmutableList omniEclipseProjects = FluentIterable.from(eclipseProjects).transform((Function)new Function<EclipseProject, OmniEclipseProject>(){

                    public OmniEclipseProject apply(EclipseProject eclipseProject) {
                        boolean isPublicFixRequired = DefaultCompositeModelRepository.this.isPublicFixRequired(eclipseProject, transientAttributes);
                        return DefaultOmniEclipseProject.from(eclipseProject, isPublicFixRequired, knownProjects);
                    }
                }).toList();
                return DefaultOmniEclipseWorkspace.from((List<OmniEclipseProject>)omniEclipseProjects);
            }
        };
        return this.executeRequest(modelRequest, successHandler, fetchStrategy, OmniEclipseWorkspace.class, converter);
    }

    private <T> CompositeModelRequest<T> createModelRequest(Class<T> model, Set<FixedRequestAttributes> fixedAttributes, TransientRequestAttributes transientAttributes) {
        CompositeModelRequest request = this.getToolingClient().newCompositeModelRequest(model);
        for (FixedRequestAttributes fixedRequestAttribute : fixedAttributes) {
            fixedRequestAttribute.apply((CompositeRequest<?>)request);
        }
        transientAttributes.apply((Request<?>)request);
        return request;
    }

    boolean isPublicFixRequired(EclipseProject project, TransientRequestAttributes transientAttributes) {
        for (FixedRequestAttributes attribute : this.requestAttributes) {
            if (!DefaultCompositeModelRepository.eclipseProjectIsSubProjectOf(attribute.getProjectDir(), project)) continue;
            return this.targetGradleVersionIsBetween("2.1", "2.2.1", attribute, transientAttributes);
        }
        return false;
    }

    public static boolean eclipseProjectIsSubProjectOf(File rootProjectDir, EclipseProject candidate) {
        try {
            File canonicalRootProjectDir = rootProjectDir.getCanonicalFile();
            return DefaultCompositeModelRepository.rootEclipseProject(candidate).getProjectDirectory().getCanonicalFile().equals(canonicalRootProjectDir);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static EclipseProject rootEclipseProject(EclipseProject project) {
        EclipseProject parent = project.getParent();
        return parent == null ? project : DefaultCompositeModelRepository.rootEclipseProject(parent);
    }

    private boolean targetGradleVersionIsBetween(String minVersion, String maxVersion, FixedRequestAttributes fixedAttributes, TransientRequestAttributes transientRequestAttributes) {
        SimpleModelRepository simpleRepo = this.modelRepositoryProvider.getModelRepository(fixedAttributes);
        OmniBuildEnvironment buildEnvironment = simpleRepo.fetchBuildEnvironment(transientRequestAttributes, FetchStrategy.LOAD_IF_NOT_CACHED);
        GradleVersion gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version((String)minVersion)) >= 0 && gradleVersion.getBaseVersion().compareTo(GradleVersion.version((String)maxVersion)) <= 0;
    }
}

