/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import com.gradleware.tooling.toolingmodel.Path;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.io.File;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.util.collections.CollectionsUtils;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.file.RelativePathUtils;
import org.eclipse.buildship.core.util.gradle.GradleDistributionSerializer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

final class ProjectConfigurationProperties {
    private final String projectPath;
    private final String projectDir;
    private final String gradleUserHome;
    private final String gradleDistribution;
    private final String javaHome;
    private final String jvmArguments;
    private final String arguments;

    private ProjectConfigurationProperties(String projectPath, String projectDir, String gradleUserHome, String gradleDistribution, String javaHome, String jvmArguments, String arguments) {
        this.projectPath = projectPath;
        this.projectDir = projectDir;
        this.gradleUserHome = gradleUserHome;
        this.gradleDistribution = gradleDistribution;
        this.javaHome = javaHome;
        this.jvmArguments = jvmArguments;
        this.arguments = arguments;
    }

    String getProjectPath() {
        return this.projectPath;
    }

    String getProjectDir() {
        return this.projectDir;
    }

    String getGradleUserHome() {
        return this.gradleUserHome;
    }

    String getGradleDistribution() {
        return this.gradleDistribution;
    }

    String getJavaHome() {
        return this.javaHome;
    }

    String getJvmArguments() {
        return this.jvmArguments;
    }

    String getArguments() {
        return this.arguments;
    }

    static ProjectConfigurationProperties from(String projectPath, String projectDir, String gradleUserHome, String gradleDistribution, String javaHome, String jvmArguments, String arguments) {
        return new ProjectConfigurationProperties(projectPath, projectDir, gradleUserHome, gradleDistribution, javaHome, jvmArguments, arguments);
    }

    static ProjectConfigurationProperties from(IProject project, ProjectConfiguration projectConfiguration) {
        String projectPath = projectConfiguration.getProjectPath().getPath();
        String projectDir = ProjectConfigurationProperties.relativePathToRootProject(project, projectConfiguration.getRequestAttributes().getProjectDir());
        String gradleUserHome = (String)FileUtils.getAbsolutePath(projectConfiguration.getRequestAttributes().getGradleUserHome()).orNull();
        String gradleDistribution = GradleDistributionSerializer.INSTANCE.serializeToString(projectConfiguration.getRequestAttributes().getGradleDistribution());
        String javaHome = (String)FileUtils.getAbsolutePath(projectConfiguration.getRequestAttributes().getJavaHome()).orNull();
        String jvmArguments = CollectionsUtils.joinWithSpace(projectConfiguration.getRequestAttributes().getJvmArguments());
        String arguments = CollectionsUtils.joinWithSpace(projectConfiguration.getRequestAttributes().getArguments());
        return ProjectConfigurationProperties.from(projectPath, projectDir, gradleUserHome, gradleDistribution, javaHome, jvmArguments, arguments);
    }

    private static String relativePathToRootProject(IProject project, File rootProjectDir) {
        org.eclipse.core.runtime.Path rootProjectPath = new org.eclipse.core.runtime.Path(rootProjectDir.getPath());
        IPath projectPath = project.getLocation();
        return RelativePathUtils.getRelativePath(projectPath, (IPath)rootProjectPath).toOSString();
    }

    ProjectConfiguration toProjectConfiguration(IProject project) {
        FixedRequestAttributes requestAttributes = new FixedRequestAttributes(ProjectConfigurationProperties.rootProjectFile(project, this.getProjectDir()), (File)FileUtils.getAbsoluteFile(this.getGradleUserHome()).orNull(), GradleDistributionSerializer.INSTANCE.deserializeFromString(this.getGradleDistribution()), (File)FileUtils.getAbsoluteFile(this.getJavaHome()).orNull(), CollectionsUtils.splitBySpace(this.getJvmArguments()), CollectionsUtils.splitBySpace(this.getArguments()));
        return ProjectConfiguration.from(requestAttributes, Path.from((String)this.getProjectPath()));
    }

    private static File rootProjectFile(IProject project, String pathToRootProject) {
        org.eclipse.core.runtime.Path rootPath = new org.eclipse.core.runtime.Path(pathToRootProject);
        if (rootPath.isAbsolute()) {
            return rootPath.toFile();
        }
        return RelativePathUtils.getAbsolutePath(project.getLocation(), (IPath)rootPath).toFile();
    }
}

