/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.collect.Lists;
import com.gradleware.tooling.toolingmodel.OmniClasspathAttribute;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniExternalDependency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.buildship.core.UnsupportedConfigurationException;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

final class WtpClasspathUpdater {
    private static final String DEPLOYMENT_ATTRIBUTE = "org.eclipse.jst.component.dependency";
    private static final String NON_DEPLOYMENT_ATTRIBUTE = "org.eclipse.jst.component.nondependency";

    WtpClasspathUpdater() {
    }

    public static void update(IJavaProject javaProject, OmniEclipseProject project, SubMonitor progress) throws JavaModelException {
        List dependencies = project.getExternalDependencies();
        String deploymentPath = WtpClasspathUpdater.getDeploymentPath(dependencies);
        if (deploymentPath != null) {
            WtpClasspathUpdater.updateDeploymentPath(javaProject, deploymentPath, progress);
        } else if (WtpClasspathUpdater.hasNonDeploymentAttributes(dependencies)) {
            WtpClasspathUpdater.markAsNonDeployed(javaProject, progress);
        }
    }

    private static String getDeploymentPath(List<OmniExternalDependency> dependencies) {
        String deploymentPath = null;
        for (OmniExternalDependency dependency : dependencies) {
            List attributes = dependency.getClasspathAttributes().isPresent() ? (List)dependency.getClasspathAttributes().get() : Collections.emptyList();
            for (OmniClasspathAttribute attribute : attributes) {
                if (!attribute.getName().equals(DEPLOYMENT_ATTRIBUTE)) continue;
                if (deploymentPath != null && !deploymentPath.equals(attribute.getValue())) {
                    throw new UnsupportedConfigurationException("WTP currently does not support mixed deployment paths.");
                }
                deploymentPath = attribute.getValue();
            }
        }
        return deploymentPath;
    }

    private static boolean hasNonDeploymentAttributes(List<OmniExternalDependency> dependencies) {
        for (OmniExternalDependency dependency : dependencies) {
            List attributes = dependency.getClasspathAttributes().isPresent() ? (List)dependency.getClasspathAttributes().get() : Collections.emptyList();
            for (OmniClasspathAttribute attribute : attributes) {
                if (!attribute.getName().equals(NON_DEPLOYMENT_ATTRIBUTE)) continue;
                return true;
            }
        }
        return false;
    }

    private static void updateDeploymentPath(IJavaProject javaProject, String deploymentPath, SubMonitor progress) throws JavaModelException {
        WtpClasspathUpdater.replaceGradleClasspathContainerAttribute(javaProject, DEPLOYMENT_ATTRIBUTE, deploymentPath, NON_DEPLOYMENT_ATTRIBUTE, progress);
    }

    private static void markAsNonDeployed(IJavaProject javaProject, SubMonitor progress) throws JavaModelException {
        WtpClasspathUpdater.replaceGradleClasspathContainerAttribute(javaProject, NON_DEPLOYMENT_ATTRIBUTE, "", DEPLOYMENT_ATTRIBUTE, progress);
    }

    private static void replaceGradleClasspathContainerAttribute(IJavaProject project, String plusKey, String plusValue, String minusKey, SubMonitor progress) throws JavaModelException {
        IClasspathEntry[] oldClasspath = project.getRawClasspath();
        IClasspathEntry[] newClasspath = new IClasspathEntry[oldClasspath.length];
        for (int i = 0; i < oldClasspath.length; ++i) {
            IClasspathEntry entry = oldClasspath[i];
            if (WtpClasspathUpdater.isGradleClasspathContainer(entry)) {
                IClasspathAttribute[] attributes = WtpClasspathUpdater.replaceClasspathAttribute(entry.getExtraAttributes(), plusKey, plusValue, minusKey);
                newClasspath[i] = JavaCore.newContainerEntry((IPath)entry.getPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])attributes, (boolean)entry.isExported());
                continue;
            }
            newClasspath[i] = entry;
        }
        project.setRawClasspath(newClasspath, (IProgressMonitor)progress);
    }

    private static boolean isGradleClasspathContainer(IClasspathEntry entry) {
        return entry.getEntryKind() == 5 && entry.getPath().equals(GradleClasspathContainer.CONTAINER_PATH);
    }

    private static IClasspathAttribute[] replaceClasspathAttribute(IClasspathAttribute[] attributes, String plusKey, String plusValue, String minusKey) {
        ArrayList attributesList = Lists.newArrayList((Object[])attributes);
        ListIterator<IClasspathAttribute> iterator = attributesList.listIterator();
        boolean plusPresent = false;
        while (iterator.hasNext()) {
            IClasspathAttribute attribute = (IClasspathAttribute)iterator.next();
            if (attribute.getName().equals(minusKey)) {
                iterator.remove();
                continue;
            }
            if (!attribute.getName().equals(plusKey)) continue;
            plusPresent = true;
            if (attribute.getValue().equals(plusValue)) continue;
            iterator.set(JavaCore.newClasspathAttribute((String)plusKey, (String)plusValue));
        }
        if (!plusPresent) {
            attributesList.add(JavaCore.newClasspathAttribute((String)plusKey, (String)plusValue));
        }
        return attributesList.toArray(new IClasspathAttribute[attributesList.size()]);
    }
}

