/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.configuration.ConfigurationManager;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.core.internal.workspace.NewProjectHandler;
import org.eclipse.buildship.core.internal.workspace.ProjectConfigurators;
import org.eclipse.buildship.core.internal.workspace.ProjectNameUpdater;
import org.eclipse.buildship.core.internal.workspace.SynchronizationProblem;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class SynchronizeGradleBuildOperation {
    private final Set<EclipseProject> allProjects;
    private final InternalGradleBuild gradleBuild;
    private final NewProjectHandler newProjectHandler;
    private final ProjectConfigurators configurators;
    private List<SynchronizationProblem> failures;

    public SynchronizeGradleBuildOperation(Set<EclipseProject> allProjects, InternalGradleBuild gradleBuild, NewProjectHandler newProjectHandler, ProjectConfigurators configurators) {
        this.allProjects = allProjects;
        this.gradleBuild = gradleBuild;
        this.newProjectHandler = newProjectHandler;
        this.configurators = configurators;
    }

    public List<SynchronizationProblem> run(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setTaskName(String.format("Synchronizing Gradle build at %s", this.gradleBuild.getBuildConfig().getRootProjectDirectory()));
        this.failures = new ArrayList<SynchronizationProblem>();
        this.synchronizeProjectsWithWorkspace(progress);
        return this.failures;
    }

    private void synchronizeProjectsWithWorkspace(SubMonitor progress) throws CoreException {
        List<IProject> decoupledWorkspaceProjects = this.getOpenWorkspaceProjectsRemovedFromGradleBuild();
        progress.setWorkRemaining(decoupledWorkspaceProjects.size() + this.allProjects.size() + 1);
        this.failures.addAll(this.configurators.initConfigurators((IProgressMonitor)progress.newChild(1)));
        for (IProject project : decoupledWorkspaceProjects) {
            this.uncoupleWorkspaceProjectFromGradle(project, progress.newChild(1));
        }
        for (final EclipseProject gradleProject : this.allProjects) {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    SynchronizeGradleBuildOperation.this.synchronizeGradleProjectWithWorkspaceProject(gradleProject, SubMonitor.convert((IProgressMonitor)monitor));
                }
            }, (IProgressMonitor)progress.newChild(1));
        }
    }

    private List<IProject> getOpenWorkspaceProjectsRemovedFromGradleBuild() {
        ImmutableSet gradleProjectDirectories = FluentIterable.from(this.allProjects).transform((Function)new Function<EclipseProject, File>(){

            public File apply(EclipseProject gradleProject) {
                return gradleProject.getProjectDirectory();
            }
        }).toSet();
        ImmutableList<IProject> allWorkspaceProjects = CorePlugin.workspaceOperations().getAllProjects();
        return FluentIterable.from(allWorkspaceProjects).filter(GradleProjectNature.isPresentOn()).filter((Predicate)new Predicate<IProject>((Set)gradleProjectDirectories){
            final /* synthetic */ Set val$gradleProjectDirectories;
            {
                this.val$gradleProjectDirectories = set;
            }

            public boolean apply(IProject project) {
                ProjectConfiguration projectConfiguration = CorePlugin.configurationManager().tryLoadProjectConfiguration(project);
                if (projectConfiguration != null) {
                    BuildConfiguration buildConfiguration = projectConfiguration.getBuildConfiguration();
                    return buildConfiguration.getRootProjectDirectory().equals(SynchronizeGradleBuildOperation.this.gradleBuild.getBuildConfig().getRootProjectDirectory()) && (project.getLocation() == null || !this.val$gradleProjectDirectories.contains(project.getLocation().toFile()));
                }
                return false;
            }
        }).toList();
    }

    private void synchronizeGradleProjectWithWorkspaceProject(EclipseProject project, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(1);
        progress.subTask(String.format("Synchronize Gradle project %s with workspace project", project.getName()));
        Optional<IProject> workspaceProject = CorePlugin.workspaceOperations().findProjectByLocation(project.getProjectDirectory());
        SubMonitor childProgress = progress.newChild(1, 7);
        if (workspaceProject.isPresent()) {
            this.synchronizeWorkspaceProject(project, (IProject)workspaceProject.get(), childProgress);
        } else if (project.getProjectDirectory().exists() && this.newProjectHandler.shouldImportNewProjects()) {
            this.synchronizeNonWorkspaceProject(project, childProgress);
        }
    }

    private void synchronizeWorkspaceProject(EclipseProject project, IProject workspaceProject, SubMonitor progress) throws CoreException {
        if (workspaceProject.isAccessible()) {
            this.synchronizeOpenWorkspaceProject(project, workspaceProject, true, progress);
        } else {
            this.synchronizeClosedWorkspaceProject(progress);
        }
    }

    private void synchronizeOpenWorkspaceProject(EclipseProject project, IProject workspaceProject, boolean refreshNeeded, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(10);
        if (refreshNeeded) {
            CorePlugin.workspaceOperations().refreshProject(workspaceProject, (IProgressMonitor)progress.newChild(1));
        } else {
            progress.worked(1);
        }
        ConfigurationManager configManager = CorePlugin.configurationManager();
        ProjectConfiguration projectConfig = configManager.createProjectConfiguration(this.gradleBuild.getBuildConfig(), project.getProjectDirectory());
        configManager.saveProjectConfiguration(projectConfig);
        workspaceProject = ProjectNameUpdater.updateProjectName(workspaceProject, project, this.allProjects, (IProgressMonitor)progress.newChild(1));
        CorePlugin.workspaceOperations().addNature(workspaceProject, "org.eclipse.buildship.core.gradleprojectnature", (IProgressMonitor)progress.newChild(1));
        this.failures.addAll(this.configurators.configureConfigurators(workspaceProject, (IProgressMonitor)progress.newChild(1)));
    }

    private void synchronizeClosedWorkspaceProject(SubMonitor childProgress) {
    }

    private void synchronizeNonWorkspaceProject(EclipseProject project, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(2);
        Optional<IProjectDescription> projectDescription = CorePlugin.workspaceOperations().findProjectDescriptor(project.getProjectDirectory(), (IProgressMonitor)progress.newChild(1));
        IProject workspaceProject = projectDescription.isPresent() ? this.addExistingEclipseProjectToWorkspace(project, (IProjectDescription)projectDescription.get(), progress.newChild(1)) : this.addNewEclipseProjectToWorkspace(project, progress.newChild(1));
        this.newProjectHandler.afterProjectImported(workspaceProject);
    }

    private IProject addExistingEclipseProjectToWorkspace(EclipseProject project, IProjectDescription projectDescription, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(3);
        ProjectNameUpdater.ensureProjectNameIsFree(project, this.allProjects, (IProgressMonitor)progress.newChild(1));
        IProject workspaceProject = CorePlugin.workspaceOperations().includeProject(projectDescription, (List<String>)ImmutableList.of(), (IProgressMonitor)progress.newChild(1));
        this.synchronizeOpenWorkspaceProject(project, workspaceProject, false, progress.newChild(1));
        return workspaceProject;
    }

    private IProject addNewEclipseProjectToWorkspace(EclipseProject project, SubMonitor progress) throws CoreException {
        progress.setWorkRemaining(3);
        ProjectNameUpdater.ensureProjectNameIsFree(project, this.allProjects, (IProgressMonitor)progress.newChild(1));
        IProject workspaceProject = CorePlugin.workspaceOperations().createProject(project.getName(), project.getProjectDirectory(), (List<String>)ImmutableList.of(), (IProgressMonitor)progress.newChild(1));
        this.synchronizeOpenWorkspaceProject(project, workspaceProject, false, progress.newChild(1));
        return workspaceProject;
    }

    private void uncoupleWorkspaceProjectFromGradle(IProject workspaceProject, SubMonitor monitor) {
        monitor.setWorkRemaining(4);
        monitor.subTask(String.format("Uncouple workspace project %s from Gradle", workspaceProject.getName()));
        CorePlugin.workspaceOperations().refreshProject(workspaceProject, (IProgressMonitor)monitor.newChild(1, 7));
        this.failures.addAll(this.configurators.unconfigureConfigurators(workspaceProject, (IProgressMonitor)monitor.newChild(1)));
        CorePlugin.workspaceOperations().removeNature(workspaceProject, "org.eclipse.buildship.core.gradleprojectnature", (IProgressMonitor)monitor.newChild(1, 7));
        CorePlugin.configurationManager().deleteProjectConfiguration(workspaceProject);
    }
}

