/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.workspace.GradleWorkspaceManager;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.internal.SynchronizeGradleBuildJob;
import org.eclipse.buildship.core.workspace.internal.SynchronizeGradleBuildsJob;
import org.eclipse.core.resources.IProject;

public class DefaultGradleWorkspaceManager
implements GradleWorkspaceManager {
    @Override
    public void synchronizeGradleBuild(FixedRequestAttributes attributes, NewProjectHandler newProjectHandler) {
        new SynchronizeGradleBuildJob(attributes, newProjectHandler, AsyncHandler.NO_OP, true).schedule();
    }

    @Override
    public void createGradleBuild(FixedRequestAttributes attributes, NewProjectHandler newProjectHandler, AsyncHandler initializer) {
        Preconditions.checkArgument((initializer != AsyncHandler.NO_OP ? 1 : 0) != 0, (Object)"Can't create projects with a no-op initializer");
        Preconditions.checkArgument((newProjectHandler != NewProjectHandler.NO_OP ? 1 : 0) != 0, (Object)"Can't import projects with a no-op handler");
        new SynchronizeGradleBuildJob(attributes, newProjectHandler, initializer, true).schedule();
    }

    @Override
    public void synchronizeProjects(Set<IProject> projects, NewProjectHandler newProjectHandler) {
        new SynchronizeGradleBuildsJob(this.getBuilds(projects), newProjectHandler).schedule();
    }

    private Set<FixedRequestAttributes> getBuilds(Set<IProject> projects) {
        return FluentIterable.from(projects).filter(GradleProjectNature.isPresentOn()).transform((Function)new Function<IProject, FixedRequestAttributes>(){

            public FixedRequestAttributes apply(IProject project) {
                return CorePlugin.projectConfigurationManager().readProjectConfiguration(project).getRequestAttributes();
            }
        }).toSet();
    }
}

