/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.collect.ObjectArrays;
import com.gradleware.tooling.toolingmodel.OmniJavaSourceSettings;
import java.io.File;
import java.util.Collections;
import org.eclipse.buildship.core.workspace.internal.EclipseVmUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;

final class JavaSourceSettingsUpdater {
    public static void update(IJavaProject project, OmniJavaSourceSettings sourceSettings, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        String sourceVersion = sourceSettings.getSourceLanguageLevel().getName();
        String targetVersion = sourceSettings.getTargetBytecodeLevel().getName();
        File vmLocation = sourceSettings.getTargetRuntime().getHomeDirectory();
        IVMInstall vm = EclipseVmUtil.findOrRegisterStandardVM(targetVersion, vmLocation);
        Optional<IExecutionEnvironment> executionEnvironment = EclipseVmUtil.findExecutionEnvironment(targetVersion);
        if (executionEnvironment.isPresent()) {
            JavaSourceSettingsUpdater.addExecutionEnvironmentToClasspath(project, (IExecutionEnvironment)executionEnvironment.get(), (IProgressMonitor)progress.newChild(1));
        } else {
            JavaSourceSettingsUpdater.addVmToClasspath(project, vm, (IProgressMonitor)progress.newChild(1));
        }
        boolean compilerOptionChanged = false;
        compilerOptionChanged |= JavaSourceSettingsUpdater.updateJavaProjectOptionIfNeeded(project, "org.eclipse.jdt.core.compiler.compliance", sourceVersion);
        compilerOptionChanged |= JavaSourceSettingsUpdater.updateJavaProjectOptionIfNeeded(project, "org.eclipse.jdt.core.compiler.source", sourceVersion);
        if ((compilerOptionChanged |= JavaSourceSettingsUpdater.updateJavaProjectOptionIfNeeded(project, "org.eclipse.jdt.core.compiler.codegen.targetPlatform", targetVersion)) && JavaSourceSettingsUpdater.isProjectAutoBuildingEnabled()) {
            JavaSourceSettingsUpdater.scheduleJdtBuild(project.getProject());
        }
    }

    private static void addExecutionEnvironmentToClasspath(IJavaProject project, IExecutionEnvironment executionEnvironment, IProgressMonitor monitor) throws JavaModelException {
        IPath vmPath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)executionEnvironment);
        JavaSourceSettingsUpdater.addContainerToClasspath(project, vmPath, monitor);
    }

    private static void addVmToClasspath(IJavaProject project, IVMInstall vm, IProgressMonitor monitor) throws JavaModelException {
        IPath vmPath = JavaRuntime.newJREContainerPath((IVMInstall)vm);
        JavaSourceSettingsUpdater.addContainerToClasspath(project, vmPath, monitor);
    }

    private static void addContainerToClasspath(IJavaProject project, IPath containerPath, IProgressMonitor monitor) throws JavaModelException {
        Object[] classpath = project.getRawClasspath();
        IPath defaultContainerPath = JavaRuntime.newDefaultJREContainerPath();
        for (int i = 0; i < classpath.length; ++i) {
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() != 5) continue;
            if (entry.getPath().equals(containerPath)) {
                return;
            }
            if (!defaultContainerPath.isPrefixOf(entry.getPath())) continue;
            IClasspathEntry newContainerEntry = JavaCore.newContainerEntry((IPath)containerPath);
            classpath[i] = newContainerEntry;
            project.setRawClasspath((IClasspathEntry[])classpath, monitor);
            return;
        }
        IClasspathEntry newContainerEntry = JavaCore.newContainerEntry((IPath)containerPath);
        classpath = (IClasspathEntry[])ObjectArrays.concat((Object[])classpath, (Object)newContainerEntry);
        project.setRawClasspath((IClasspathEntry[])classpath, monitor);
    }

    private static boolean updateJavaProjectOptionIfNeeded(IJavaProject project, String optionKey, String newValue) {
        String currentValue = project.getOption(optionKey, true);
        if (currentValue == null || !currentValue.equals(newValue)) {
            project.setOption(optionKey, newValue);
            return true;
        }
        return false;
    }

    private static boolean isProjectAutoBuildingEnabled() {
        return ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
    }

    private static void scheduleJdtBuild(final IProject project) {
        WorkspaceJob build = new WorkspaceJob(String.format("Building project %s after Java compiler settings changed", project.getName())){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    project.build(6, "org.eclipse.jdt.core.javabuilder", Collections.emptyMap(), monitor);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }

            public boolean belongsTo(Object family) {
                return family == ResourcesPlugin.FAMILY_AUTO_BUILD;
            }
        };
        build.schedule();
    }

    private JavaSourceSettingsUpdater() {
    }
}

