/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.gradle.api.UncheckedIOException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class ClasspathContainerPersistence {
    private final IJavaProject javaProject;

    private ClasspathContainerPersistence(IJavaProject javaProject) {
        this.javaProject = (IJavaProject)Preconditions.checkNotNull((Object)javaProject);
    }

    void save(List<IClasspathEntry> entries) {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        content.append("<classpath>\n");
        for (IClasspathEntry entry : entries) {
            content.append(this.javaProject.encodeClasspathEntry(entry));
        }
        content.append("</classpath>\n");
        File stateLocation = this.getStateLocation();
        try {
            Files.createParentDirs((File)stateLocation);
            Files.write((CharSequence)content, (File)stateLocation, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    Optional<List<IClasspathEntry>> load() {
        File stateLocation = this.getStateLocation();
        if (!stateLocation.exists()) {
            return Optional.absent();
        }
        try {
            Element classpathNode = this.readClasspathNode(stateLocation);
            List<IClasspathEntry> entries = this.readEntriesFromClasspathNode(classpathNode);
            return Optional.of(entries);
        }
        catch (Exception e) {
            CorePlugin.logger().error(String.format("Could not read persisted classpath for project %s.", this.javaProject.getProject().getName()), e);
            return Optional.absent();
        }
    }

    private Element readClasspathNode(File stateLocation) throws IOException, ParserConfigurationException, SAXException {
        byte[] bytes = Files.toByteArray((File)stateLocation);
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Element classpathNode = parser.parse(new InputSource(new ByteArrayInputStream(bytes))).getDocumentElement();
        if (!classpathNode.getNodeName().equalsIgnoreCase("classpath")) {
            throw new IllegalStateException("Classpath file does not contain a <classpath> element.");
        }
        return classpathNode;
    }

    private List<IClasspathEntry> readEntriesFromClasspathNode(Element classpathNode) throws TransformerException {
        ArrayList entries = Lists.newArrayList();
        NodeList domEntries = classpathNode.getElementsByTagName("classpathentry");
        Transformer identity = TransformerFactory.newInstance().newTransformer();
        identity.setOutputProperty("omit-xml-declaration", "yes");
        identity.setOutputProperty("indent", "yes");
        for (int i = 0; i < domEntries.getLength(); ++i) {
            Node domEntry = domEntries.item(i);
            if (domEntry.getNodeType() != 1) continue;
            String rawEntry = this.transformNodeToString(domEntry, identity);
            IClasspathEntry entry = this.javaProject.decodeClasspathEntry(rawEntry);
            if (entry == null) {
                throw new IllegalStateException(String.format("Could not parse classpath entry %s.", rawEntry));
            }
            entries.add(entry);
        }
        return entries;
    }

    private String transformNodeToString(Node node, Transformer transformer) throws TransformerException {
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(node), new StreamResult(writer));
        return writer.toString();
    }

    private File getStateLocation() {
        return CorePlugin.getInstance().getStateLocation().append("classpath-persistence").append(this.javaProject.getProject().getName()).toFile();
    }

    static void save(IJavaProject javaProject, List<IClasspathEntry> entries) {
        new ClasspathContainerPersistence(javaProject).save(entries);
    }

    static Optional<List<IClasspathEntry>> load(IJavaProject javaProject) {
        return new ClasspathContainerPersistence(javaProject).load();
    }
}

