/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.console;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.console.ConsoleMessages;
import org.eclipse.buildship.ui.console.GradleConsole;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public final class RemoveAllTerminatedGradleConsolesAction
extends Action
implements ILaunchesListener2 {
    private final GradleConsole gradleConsole;

    public RemoveAllTerminatedGradleConsolesAction(GradleConsole gradleConsole) {
        this.gradleConsole = (GradleConsole)((Object)Preconditions.checkNotNull((Object)((Object)gradleConsole)));
        this.setToolTipText(ConsoleMessages.Action_RemoveAllTerminatedConsoles_Tooltip);
        this.setImageDescriptor(PluginImages.REMOVE_ALL_CONSOLES.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setDisabledImageDescriptor(PluginImages.REMOVE_ALL_CONSOLES.withState(PluginImage.ImageState.DISABLED).getImageDescriptor());
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        this.update();
    }

    private void update() {
        this.setEnabled(this.gradleConsole.isCloseable() && this.gradleConsole.isTerminated());
    }

    private ImmutableList<GradleConsole> getTerminatedConsoles() {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        return FluentIterable.from(Arrays.asList(consoleManager.getConsoles())).filter(GradleConsole.class).filter((Predicate)new Predicate<GradleConsole>(){

            public boolean apply(GradleConsole console) {
                return console.isCloseable() && console.isTerminated();
            }
        }).toList();
    }

    public void run() {
        ImmutableList<GradleConsole> terminatedConsoles = this.getTerminatedConsoles();
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles((IConsole[])terminatedConsoles.toArray((Object[])new GradleConsole[terminatedConsoles.size()]));
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesTerminated(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.update();
    }

    public void dispose() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }
}

