/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingclient.Request;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.console.ProcessDescription;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.launch.internal.BuildExecutionParticipants;
import org.eclipse.buildship.core.launch.internal.DefaultExecuteLaunchRequestEvent;
import org.eclipse.buildship.core.util.collections.CollectionsUtils;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.gradle.GradleDistributionFormatter;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.util.progress.ToolingApiJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.gradle.tooling.ProgressListener;

public abstract class BaseLaunchRequestJob
extends ToolingApiJob {
    protected BaseLaunchRequestJob(String name, boolean notifyUserAboutBuildFailures) {
        super(name, notifyUserAboutBuildFailures);
    }

    @Override
    protected final void runToolingApiJob(IProgressMonitor monitor) {
        BuildExecutionParticipants.activateParticipantPlugins();
        monitor.beginTask(this.getJobTaskName(), -1);
        ProcessDescription processDescription = this.createProcessDescription();
        ProcessStreams processStreams = CorePlugin.processStreamsProvider().createProcessStreams(processDescription);
        ImmutableList listeners = ImmutableList.of((Object)new DelegatingProgressListener(monitor));
        TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, processStreams.getOutput(), processStreams.getError(), processStreams.getInput(), (List)listeners, (List)ImmutableList.of(), this.getToken());
        Request<Void> request = this.createRequest();
        FixedRequestAttributes fixedAttributes = this.createFixedAttributes();
        fixedAttributes.apply(request);
        request.standardOutput(processStreams.getOutput());
        request.standardError(processStreams.getError());
        request.standardInput(processStreams.getInput());
        request.progressListeners(listeners.toArray(new ProgressListener[listeners.size()]));
        request.cancellationToken(this.getToken());
        OutputStreamWriter writer = new OutputStreamWriter(processStreams.getConfiguration());
        this.writeFixedRequestAttributes(fixedAttributes, transientAttributes, writer, monitor);
        DefaultExecuteLaunchRequestEvent event = new DefaultExecuteLaunchRequestEvent(processDescription, request);
        CorePlugin.listenerRegistry().dispatch(event);
        request.executeAndWait();
    }

    private FixedRequestAttributes createFixedAttributes() {
        GradleRunConfigurationAttributes configurationAttributes = this.getConfigurationAttributes();
        File workingDir = configurationAttributes.getWorkingDir();
        File gradleUserHome = configurationAttributes.getGradleUserHome();
        GradleDistribution gradleDistribution = configurationAttributes.getGradleDistribution();
        File javaHome = configurationAttributes.getJavaHome();
        ImmutableList<String> jvmArguments = configurationAttributes.getJvmArguments();
        ImmutableList<String> arguments = configurationAttributes.getArguments();
        return new FixedRequestAttributes(workingDir, gradleUserHome, gradleDistribution, javaHome, jvmArguments, arguments);
    }

    private void writeFixedRequestAttributes(FixedRequestAttributes fixedAttributes, TransientRequestAttributes transientAttributes, OutputStreamWriter writer, IProgressMonitor monitor) {
        File javaHome;
        OmniBuildEnvironment buildEnvironment = this.fetchBuildEnvironment(fixedAttributes, transientAttributes, monitor);
        File gradleUserHome = fixedAttributes.getGradleUserHome();
        if (gradleUserHome == null) {
            gradleUserHome = (File)buildEnvironment.getGradle().getGradleUserHome().or(null);
        }
        if ((javaHome = fixedAttributes.getJavaHome()) == null) {
            javaHome = buildEnvironment.getJava().getJavaHome();
        }
        String gradleVersion = buildEnvironment.getGradle().getGradleVersion();
        try {
            writer.write(String.format("%s: %s%n", CoreMessages.RunConfiguration_Label_WorkingDirectory, fixedAttributes.getProjectDir().getAbsolutePath()));
            writer.write(String.format("%s: %s%n", CoreMessages.RunConfiguration_Label_GradleUserHome, this.toNonEmpty(gradleUserHome, CoreMessages.Value_UseGradleDefault)));
            writer.write(String.format("%s: %s%n", CoreMessages.RunConfiguration_Label_GradleDistribution, GradleDistributionFormatter.toString(fixedAttributes.getGradleDistribution())));
            writer.write(String.format("%s: %s%n", CoreMessages.RunConfiguration_Label_GradleVersion, gradleVersion));
            writer.write(String.format("%s: %s%n", CoreMessages.RunConfiguration_Label_JavaHome, this.toNonEmpty(javaHome, CoreMessages.Value_UseGradleDefault)));
            writer.write(String.format("%s: %s%n", CoreMessages.RunConfiguration_Label_JvmArguments, this.toNonEmpty(fixedAttributes.getJvmArguments(), CoreMessages.Value_None)));
            writer.write(String.format("%s: %s%n", CoreMessages.RunConfiguration_Label_Arguments, this.toNonEmpty(fixedAttributes.getArguments(), CoreMessages.Value_None)));
            this.writeExtraConfigInfo(writer);
            writer.write(10);
            writer.flush();
        }
        catch (IOException e) {
            String message = String.format("Cannot write run configuration description to Gradle console.", new Object[0]);
            CorePlugin.logger().error(message, e);
            throw new GradlePluginsRuntimeException(message, e);
        }
    }

    private String toNonEmpty(File fileValue, String defaultMessage) {
        String string = (String)FileUtils.getAbsolutePath(fileValue).orNull();
        return string != null ? string : defaultMessage;
    }

    private String toNonEmpty(List<String> stringValues, String defaultMessage) {
        String string = Strings.emptyToNull((String)CollectionsUtils.joinWithSpace(stringValues));
        return string != null ? string : defaultMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OmniBuildEnvironment fetchBuildEnvironment(FixedRequestAttributes fixedRequestAttributes, TransientRequestAttributes transientRequestAttributes, IProgressMonitor monitor) {
        monitor.beginTask("Load Gradle Build Environment", -1);
        try {
            ModelRepository repository = CorePlugin.modelRepositoryProvider().getModelRepository(fixedRequestAttributes);
            OmniBuildEnvironment omniBuildEnvironment = repository.fetchBuildEnvironment(transientRequestAttributes, FetchStrategy.FORCE_RELOAD);
            return omniBuildEnvironment;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract String getJobTaskName();

    protected abstract GradleRunConfigurationAttributes getConfigurationAttributes();

    protected abstract ProcessDescription createProcessDescription();

    protected abstract Request<Void> createRequest();

    protected abstract void writeExtraConfigInfo(OutputStreamWriter var1) throws IOException;

    protected static abstract class BaseProcessDescription
    implements ProcessDescription {
        private final String name;
        private final Job job;
        private final GradleRunConfigurationAttributes configurationAttributes;

        protected BaseProcessDescription(String name, Job job, GradleRunConfigurationAttributes configurationAttributes) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.job = (Job)Preconditions.checkNotNull((Object)job);
            this.configurationAttributes = (GradleRunConfigurationAttributes)Preconditions.checkNotNull((Object)configurationAttributes);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Job getJob() {
            return this.job;
        }

        @Override
        public GradleRunConfigurationAttributes getConfigurationAttributes() {
            return this.configurationAttributes;
        }
    }
}

