/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.exporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.polarsys.capella.xmlpivot.extraction.ConceptualMapping;

public final class ExportEngine
extends HashMap<EObject, EObject> {
    private static final long serialVersionUID = 1L;
    private final ConceptualMapping mapping;
    private final Set<EObject> unmappedObjects = new HashSet<EObject>();

    public ExportEngine(ConceptualMapping mapping_p) {
        this.mapping = mapping_p;
    }

    public Collection<EObject> getSkippedElements(Collection<? extends EObject> context) {
        ArrayList<EObject> skipped = new ArrayList<EObject>();
        TreeIterator it = EcoreUtil.getAllContents(context);
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (this.get(next) != null) continue;
            skipped.add(next);
        }
        return skipped;
    }

    public EObject copy(EObject eObject) {
        if (eObject == null) {
            throw new IllegalArgumentException();
        }
        if (this.unmappedObjects.contains(eObject)) {
            return null;
        }
        EObject copyEObject = (EObject)this.get(eObject);
        if (copyEObject == null) {
            copyEObject = this.createCopy(eObject);
            if (copyEObject != null) {
                for (EAttribute copyEAttribute : copyEObject.eClass().getEAllAttributes()) {
                    this.copyAttribute(copyEAttribute, copyEObject, eObject);
                }
                this.put(eObject, copyEObject);
            } else {
                this.unmappedObjects.add(eObject);
            }
        }
        return copyEObject;
    }

    public void copy(Iterator<EObject> iterator) {
        while (iterator.hasNext()) {
            this.copy(iterator.next());
        }
    }

    public Collection<EObject> copyAll(Collection<? extends EObject> eObjects) {
        ArrayList<EObject> result = new ArrayList<EObject>(eObjects.size());
        for (EObject eObject : eObjects) {
            EObject copy = this.copy(eObject);
            if (copy == null) continue;
            result.add(copy);
        }
        return result;
    }

    protected void copyAttribute(EAttribute copyEAttribute, EObject copyEObject, EObject eObject) {
        EAttribute eAttribute;
        if (copyEAttribute.isChangeable() && !copyEAttribute.isDerived() && eObject.eIsSet((EStructuralFeature)(eAttribute = (EAttribute)this.mapping.getTechnical((EModelElement)copyEAttribute)))) {
            if (eAttribute.getEType() instanceof EEnum) {
                this.copyEnumAttributeValue(eAttribute, eObject, copyEAttribute, copyEObject);
            } else {
                this.copyAttributeValue(eAttribute, eObject, copyEAttribute, copyEObject);
            }
        }
    }

    protected EObject createCopy(EObject eObject) {
        EClass copyEClass = (EClass)this.mapping.getSimplified((EModelElement)eObject.eClass());
        if (copyEClass != null) {
            return EcoreUtil.create((EClass)copyEClass);
        }
        return null;
    }

    public void copyReferences() {
        for (Map.Entry entry : this.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            EObject copyEObject = (EObject)entry.getValue();
            if (copyEObject == null) continue;
            for (EReference copyEReference : copyEObject.eClass().getEAllReferences()) {
                if (copyEReference.isContainer()) continue;
                this.copyCrossReference(copyEReference, copyEObject, eObject);
            }
        }
    }

    protected void copyCrossReference(EReference copyEReference, EObject copyEObject, EObject eObject) {
        EReference eReference = (EReference)this.mapping.getTechnical((EModelElement)copyEReference);
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            Object value = eObject.eGet((EStructuralFeature)eReference);
            if (eReference.isMany()) {
                InternalEList source = (InternalEList)value;
                InternalEList target = (InternalEList)copyEObject.eGet((EStructuralFeature)copyEReference);
                boolean isBidirectional = copyEReference.getEOpposite() != null;
                int index = 0;
                for (EObject referencedEObject : source) {
                    EObject copyReferencedEObject = (EObject)this.get(referencedEObject);
                    if (copyReferencedEObject == null) continue;
                    if (isBidirectional) {
                        int position = target.indexOf((Object)copyReferencedEObject);
                        if (position == -1) {
                            target.addUnique(index, (Object)copyReferencedEObject);
                        } else if (index != position) {
                            target.move(index, (Object)copyReferencedEObject);
                        }
                    } else if (eReference.isDerived()) {
                        target.add((Object)copyReferencedEObject);
                    } else {
                        target.addUnique((Object)copyReferencedEObject);
                    }
                    ++index;
                }
            } else {
                EObject targetValue = (EObject)this.get(value);
                if (targetValue != null) {
                    copyEObject.eSet((EStructuralFeature)copyEReference, (Object)targetValue);
                }
            }
        }
    }

    protected void copyAttributeValue(EAttribute sourceAttribute, EObject sourceElement, EAttribute targetAttribute, EObject targetElement) {
        targetElement.eSet((EStructuralFeature)targetAttribute, sourceElement.eGet((EStructuralFeature)sourceAttribute));
    }

    protected void copyEnumAttributeValue(EAttribute sourceAttribute, EObject sourceElement, EAttribute targetAttribute, EObject targetElement) {
        Object targetValue = null;
        if (sourceAttribute.isMany()) {
            BasicEList newListValue = new BasicEList();
            for (Object o : (EList)sourceElement.eGet((EStructuralFeature)sourceAttribute)) {
                newListValue.add(EcoreUtil.createFromString((EDataType)((EDataType)targetAttribute.getEType()), (String)((Enumerator)o).getLiteral()));
            }
            targetValue = newListValue;
        } else {
            targetValue = EcoreUtil.createFromString((EDataType)((EDataType)targetAttribute.getEType()), (String)((Enumerator)sourceElement.eGet((EStructuralFeature)sourceAttribute)).getLiteral());
        }
        targetElement.eSet((EStructuralFeature)targetAttribute, targetValue);
    }

    public Collection<? extends Object> getUnmappedObjects() {
        return Collections.unmodifiableCollection(this.unmappedObjects);
    }
}

