/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.importer;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityExtend;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityGeneralization;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityInclude;
import org.polarsys.capella.xmlpivot.common.CapellaDerivedFeatureMetadata;
import org.polarsys.capella.xmlpivot.common.predicates.EMFPredicates;
import org.polarsys.capella.xmlpivot.extraction.ConceptualMapping;
import org.polarsys.capella.xmlpivot.importer.CsImportAdapterFactory;
import org.polarsys.capella.xmlpivot.importer.FaImportAdapterFactory;
import org.polarsys.capella.xmlpivot.importer.ImportAdapter;
import org.polarsys.capella.xmlpivot.importer.InteractionImportAdapterFactory;

public class ImportEngine
extends EcoreUtil.Copier {
    private final Collection<EObject> orphanedRecreatedAssociationLinks = new ArrayList<EObject>();
    private final ConceptualMapping mapping;

    public ImportEngine(ConceptualMapping mapping_p) {
        this.mapping = mapping_p;
    }

    public ConceptualMapping getMapping() {
        return this.mapping;
    }

    protected EClass getTarget(EClass simplifiedEClass) {
        EClass targetClass = (EClass)this.mapping.getTechnical((EModelElement)simplifiedEClass);
        if (targetClass == null) {
            throw new IllegalStateException("No technical class found for: " + simplifiedEClass);
        }
        return targetClass;
    }

    protected EStructuralFeature getTarget(EStructuralFeature eStructuralFeature) {
        return (EStructuralFeature)this.mapping.getTechnical((EModelElement)eStructuralFeature);
    }

    protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
        try {
            EStructuralFeature targetFeature = this.getTarget((EStructuralFeature)eReference);
            if (targetFeature.isDerived()) {
                this.copyReferenceToHoldingFeature(eReference, eObject, copyEObject);
                this.recreateLinks(eReference, eObject, copyEObject);
            } else {
                super.copyReference(eReference, eObject, copyEObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void recreateLinks(EReference eReference, EObject eObject, EObject copyEObject) {
        EClass associationClass = CapellaDerivedFeatureMetadata.INSTANCE.getAssociationClass((EReference)this.getTarget((EStructuralFeature)eReference));
        if (associationClass != null) {
            if (eReference.isMany()) {
                for (EObject referenced : (List)eObject.eGet((EStructuralFeature)eReference)) {
                    this.link(copyEObject, (EObject)this.get(referenced), associationClass);
                }
            } else if (eObject.eGet((EStructuralFeature)eReference) != null) {
                this.link(copyEObject, (EObject)this.get(eObject.eGet((EStructuralFeature)eReference)), associationClass);
            }
        }
    }

    protected void copyReferenceToHoldingFeature(EReference eReference, EObject eObject, EObject copyEObject) {
        EReference holdingReference = (EReference)CapellaDerivedFeatureMetadata.INSTANCE.getHoldingFeature(this.getTarget((EStructuralFeature)eReference));
        if (holdingReference != null) {
            if (holdingReference.isMany()) {
                List heldValues = (List)copyEObject.eGet((EStructuralFeature)holdingReference);
                if (eReference.isMany()) {
                    for (EObject referencedObject : (List)eObject.eGet((EStructuralFeature)eReference)) {
                        EObject copyReferencedObject = null;
                        copyReferencedObject = holdingReference.isContainment() ? this.copy(referencedObject) : (EObject)this.get(referencedObject);
                        if (copyReferencedObject == null) continue;
                        heldValues.add(copyReferencedObject);
                    }
                } else {
                    EObject copyReferencedObject = null;
                    copyReferencedObject = holdingReference.isContainment() ? this.copy((EObject)eObject.eGet((EStructuralFeature)eReference)) : (EObject)this.get(eObject.eGet((EStructuralFeature)eReference));
                    this.get(eObject.eGet((EStructuralFeature)eReference));
                    if (copyReferencedObject != null) {
                        heldValues.add(copyReferencedObject);
                    }
                }
            } else {
                EObject copyReferencedObject = null;
                copyReferencedObject = holdingReference.isContainment() ? this.copy((EObject)eObject.eGet((EStructuralFeature)eReference)) : (EObject)this.get(eObject.eGet((EStructuralFeature)eReference));
                if (copyReferencedObject != null) {
                    copyEObject.eSet((EStructuralFeature)holdingReference, (Object)copyReferencedObject);
                }
            }
        }
    }

    private void attachLink(EObject context, EObject link) {
        if (link.eContainer() == null) {
            while (link.eContainer() == null && context != null) {
                for (EReference ref : context.eClass().getEAllContainments()) {
                    if (!ref.getEType().isInstance((Object)link)) continue;
                    if (ref.isMany()) {
                        ((EList)context.eGet((EStructuralFeature)ref)).add((Object)link);
                    } else {
                        context.eSet((EStructuralFeature)ref, (Object)link);
                    }
                    return;
                }
                context = context.eContainer();
            }
            this.orphanedRecreatedAssociationLinks.add(link);
        }
    }

    private void link(EObject source, EObject target, EClass associationClass) {
        EObject link = EcoreUtil.create((EClass)associationClass);
        if (link instanceof AbstractTrace) {
            ((AbstractTrace)link).setSourceElement((TraceableElement)source);
            ((AbstractTrace)link).setTargetElement((TraceableElement)target);
        } else if (link instanceof Involvement) {
            ((Involvement)link).setInvolver((InvolverElement)source);
            ((Involvement)link).setInvolved((InvolvedElement)target);
        } else if (link instanceof Generalization) {
            ((Generalization)link).setSub((GeneralizableElement)source);
            ((Generalization)link).setSuper((GeneralizableElement)target);
        } else if (link instanceof CapabilityExploitation) {
            ((CapabilityExploitation)link).setMission((Mission)source);
            ((CapabilityExploitation)link).setCapability((Capability)target);
        } else if (link instanceof AbstractDeploymentLink) {
            ((AbstractDeploymentLink)link).setLocation((DeploymentTarget)source);
            ((AbstractDeploymentLink)link).setDeployedElement((DeployableElement)target);
        } else if (link instanceof AbstractCapabilityGeneralization) {
            ((AbstractCapabilityGeneralization)link).setSuper((AbstractCapability)target);
        } else if (link instanceof AbstractCapabilityExtend) {
            ((AbstractCapabilityExtend)link).setExtended((AbstractCapability)target);
        } else if (link instanceof AbstractCapabilityInclude) {
            ((AbstractCapabilityInclude)link).setIncluded((AbstractCapability)target);
        } else if (link instanceof InterfaceUse) {
            ((InterfaceUse)link).setUsedInterface((Interface)target);
        } else if (link instanceof InterfaceImplementation) {
            ((InterfaceImplementation)link).setImplementedInterface((Interface)target);
        }
        if (link instanceof ModelElement) {
            ((ModelElement)link).getId();
        }
        this.attachLink(source, link);
    }

    protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        if (this.getTarget((EStructuralFeature)eReference).isDerived()) {
            this.copyReferenceToHoldingFeature(eReference, eObject, copyEObject);
        } else {
            super.copyContainment(eReference, eObject, copyEObject);
        }
    }

    protected void copyAttribute(EAttribute eAttribute_p, EObject eObject_p, EObject copyEObject_p) {
        if (!this.getTarget((EStructuralFeature)eAttribute_p).isDerived()) {
            if (eAttribute_p.getEType() instanceof EEnum) {
                this.copyEnumAttributeValue(eAttribute_p, eObject_p, (EAttribute)this.getTarget((EStructuralFeature)eAttribute_p), copyEObject_p);
            } else {
                super.copyAttribute(eAttribute_p, eObject_p, copyEObject_p);
            }
        }
    }

    protected void copyEnumAttributeValue(EAttribute sourceAttribute, EObject sourceElement, EAttribute targetAttribute, EObject targetElement) {
        Object targetValue = null;
        if (sourceAttribute.isMany()) {
            BasicEList newListValue = new BasicEList();
            for (Object o : (EList)sourceElement.eGet((EStructuralFeature)sourceAttribute)) {
                newListValue.add(EcoreUtil.createFromString((EDataType)((EDataType)targetAttribute.getEType()), (String)((Enumerator)o).getLiteral()));
            }
            targetValue = newListValue;
        } else {
            targetValue = EcoreUtil.createFromString((EDataType)((EDataType)targetAttribute.getEType()), (String)((Enumerator)sourceElement.eGet((EStructuralFeature)sourceAttribute)).getLiteral());
        }
        targetElement.eSet((EStructuralFeature)targetAttribute, targetValue);
    }

    public Collection<EObject> getOrphanedRecreatedAssociationLinks() {
        return this.orphanedRecreatedAssociationLinks;
    }

    public void repair() {
        Collection technicalRootContainers = Collections2.filter((Collection)this.values(), (Predicate)EMFPredicates.isRootContainer());
        Collection simplifiedRootContainers = Collections2.filter((Collection)this.keySet(), (Predicate)EMFPredicates.isRootContainer());
        ComposedAdapterFactory factory = new ComposedAdapterFactory();
        factory.addAdapterFactory((AdapterFactory)new InteractionImportAdapterFactory());
        factory.addAdapterFactory((AdapterFactory)new FaImportAdapterFactory());
        factory.addAdapterFactory((AdapterFactory)new CsImportAdapterFactory());
        ChangeAdapter changeAdapter = new ChangeAdapter();
        for (EObject tr : technicalRootContainers) {
            tr.eAdapters().add((Object)changeAdapter);
        }
        while (changeAdapter.hasChanged()) {
            changeAdapter.clear();
            TreeIterator it = EcoreUtil.getAllContents((Collection)simplifiedRootContainers);
            while (it.hasNext()) {
                EObject simplified = (EObject)it.next();
                ImportAdapter adapter = (ImportAdapter)factory.adapt((Notifier)this.get(simplified), ImportAdapter.class);
                if (adapter == null) continue;
                adapter.doImport((EObject)this.get(simplified), simplified, this);
            }
        }
        for (EObject tr : technicalRootContainers) {
            tr.eAdapters().remove((Object)changeAdapter);
        }
    }

    protected class ChangeAdapter
    extends EContentAdapter {
        private boolean changed = true;

        protected ChangeAdapter() {
        }

        public void clear() {
            this.changed = false;
        }

        public boolean hasChanged() {
            return this.changed;
        }

        public void notifyChanged(Notification notification_p) {
            if (!notification_p.isTouch()) {
                this.changed = true;
            }
        }
    }
}

