/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.extraction;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.polarsys.capella.core.model.semantic.SimplifiedCapellaMetadata;
import org.polarsys.capella.xmlpivot.common.XMLPivotMetadata;
import org.polarsys.capella.xmlpivot.extraction.ConceptualMapping;

public class BasicConceptualMapping
implements ConceptualMapping {
    protected final SimplifiedCapellaMetadata metadata;
    protected final EPackage.Registry registry;
    protected final EcoreSwitch<EModelElement> technicalToSimplified = new EcoreSwitch<EModelElement>(){

        public EModelElement caseEStructuralFeature(EStructuralFeature object_p) {
            EClass simplified = BasicConceptualMapping.this.getSimplified(object_p.getEContainingClass());
            if (simplified != null) {
                for (EStructuralFeature f : simplified.getEAllStructuralFeatures()) {
                    if (!BasicConceptualMapping.this.metadata.getSimplifiedName((ENamedElement)object_p).equals(f.getName())) continue;
                    return f;
                }
            }
            return null;
        }

        public EModelElement caseEClassifier(EClassifier object_p) {
            EPackage simplifiedPackage = BasicConceptualMapping.this.getSimplified(object_p.getEPackage());
            return simplifiedPackage == null ? null : simplifiedPackage.getEClassifier(BasicConceptualMapping.this.metadata.getSimplifiedName((ENamedElement)object_p));
        }

        public EModelElement caseEPackage(EPackage object_p) {
            EPackage simplifiedPackage = BasicConceptualMapping.this.registry.getEPackage(BasicConceptualMapping.this.metadata.getSimplifiedNsURI(object_p));
            if (simplifiedPackage == null) {
                simplifiedPackage = BasicConceptualMapping.this.delegateGetSimplifiedPackage(object_p);
            }
            return simplifiedPackage;
        }
    };
    private final EcoreSwitch<EModelElement> simplifiedToTechnical = new EcoreSwitch<EModelElement>(){

        public EModelElement caseEClassifier(EClassifier simplified_p) {
            EClassifier result = this.getTechnicalFromRegistry(simplified_p, BasicConceptualMapping.this.registry);
            if (result == null) {
                result = this.getTechnicalFromRegistry(simplified_p, EPackage.Registry.INSTANCE);
            }
            return result;
        }

        public EModelElement caseEStructuralFeature(EStructuralFeature simplified_p) {
            EClass technicalClass = BasicConceptualMapping.this.getTechnical(simplified_p.getEContainingClass());
            if (technicalClass != null) {
                for (EStructuralFeature feature : technicalClass.getEAllStructuralFeatures()) {
                    if (!BasicConceptualMapping.this.metadata.getSimplifiedName((ENamedElement)feature).equals(simplified_p.getName())) continue;
                    return feature;
                }
            }
            return null;
        }

        private EClassifier getTechnicalFromRegistry(EClassifier simplified, EPackage.Registry registry) {
            EPackage source;
            EPackage simplifiedPackage = simplified.getEPackage();
            String sourceNsURI = XMLPivotMetadata.INSTANCE.getSourceNsURI(simplifiedPackage);
            if (sourceNsURI != null && (source = registry.getEPackage(sourceNsURI)) != null) {
                for (EClassifier c : source.getEClassifiers()) {
                    if (!BasicConceptualMapping.this.metadata.getSimplifiedName((ENamedElement)c).equals(simplified.getName())) continue;
                    return c;
                }
            }
            return null;
        }
    };

    public BasicConceptualMapping(EPackage.Registry registry_p) {
        this.registry = registry_p;
        this.metadata = SimplifiedCapellaMetadata.INSTANCE;
    }

    protected EPackage delegateGetSimplifiedPackage(EPackage package_p) {
        return null;
    }

    @Override
    public <T extends EModelElement> T getSimplified(T technical_p) {
        EModelElement t = (EModelElement)this.technicalToSimplified.doSwitch(technical_p);
        return (T)t;
    }

    @Override
    public <T extends EModelElement> T getTechnical(T simplified_p) {
        return (T)((EModelElement)this.simplifiedToTechnical.doSwitch(simplified_p));
    }
}

