/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.test;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.After;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.xmlpivot.test.Model;
import org.polarsys.capella.xmlpivot.test.XMLPivotTest;
import org.polarsys.capella.xmlpivot.test.XMLPivotTestUtil;

public abstract class XMLPivotRoundTripTest
extends XMLPivotTest {
    public static final String DEFAULT_FIXTURES_LOCATION = "platform:/plugin/org.polarsys.capella.xmlpivot.test/fixtures/";
    protected Resource inputResource;
    protected Collection<EObject> inputElements;
    protected Collection<EObject> exportResult;
    protected Collection<EObject> importResult;
    protected XMLPivotTestUtil util;
    ExecutionManager manager;

    @After
    public void tearDown() {
        this.inputElements = null;
        this.exportResult = null;
        this.importResult = null;
        this.inputResource.unload();
        this.manager.getEditingDomain().dispose();
    }

    public void setUp() throws Exception {
        Model model = ((Object)((Object)this)).getClass().getMethod(this.getName(), new Class[0]).getAnnotation(Model.class);
        if (model == null) {
            model = ((Object)((Object)this)).getClass().getAnnotation(Model.class);
        }
        if (model == null) {
            throw new IllegalArgumentException("No @Model annotation found to load input");
        }
        this.manager = ExecutionManagerRegistry.getInstance().addNewManager();
        URI uri = URI.createURI((String)model.uri());
        this.inputResource = this.manager.getEditingDomain().getResourceSet().getResource(uri, true);
        if (model.elements() == null || model.elements().length == 0) {
            this.inputElements = new ArrayList<EObject>((Collection<EObject>)this.inputResource.getContents());
        } else {
            String[] stringArray = model.elements();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                this.inputElements = new ArrayList<EObject>();
                EObject e = this.inputResource.getEObject(id);
                if (e == null) {
                    throw new IllegalArgumentException("Could not find element with id: " + id);
                }
                this.inputElements.add(e);
                ++n2;
            }
        }
        this.exportResult = this.exporter(this.inputElements);
        this.importResult = this.importer(this.exportResult);
        this.util = new XMLPivotTestUtil(uri, this.inputElements, this.importResult);
    }
}

