/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.fa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ComponentPortKind implements Enumerator
{
    STANDARD(0, "STANDARD", "STANDARD"),
    FLOW(1, "FLOW", "FLOW");

    public static final int STANDARD_VALUE = 0;
    public static final int FLOW_VALUE = 1;
    private static final ComponentPortKind[] VALUES_ARRAY;
    public static final List<ComponentPortKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ComponentPortKind[]{STANDARD, FLOW};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ComponentPortKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComponentPortKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComponentPortKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComponentPortKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComponentPortKind get(int value) {
        switch (value) {
            case 0: {
                return STANDARD;
            }
            case 1: {
                return FLOW;
            }
        }
        return null;
    }

    private ComponentPortKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

