/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.merge.temp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IAttributeValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.impl.helpers.DiffOperation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.model.semantic.SimplifiedCapellaMetadata;
import org.polarsys.capella.xmlpivot.merge.specification.XMLPivotDiffPolicy;

public class XMLPivotDiffOperation
extends DiffOperation {
    public XMLPivotDiffOperation(IComparison.Editable comparison_p, IDiffPolicy diffPolicy_p, IMergePolicy mergePolicy_p) {
        super(comparison_p, diffPolicy_p, mergePolicy_p);
    }

    protected void createDifferences() {
        for (IMatch match : this.getMapping().getContents()) {
            this.checkProgress();
            if (this.getCastedDiffPolicy().coverMatch(match)) {
                this.createTechnicalDifferences(match);
            }
            this.getMonitor().worked(1);
        }
    }

    protected IElementPresence getOrCreateElementPresence(IMatch match_p) {
        IElementPresence result = null;
        if (this.getCastedDiffPolicy().coverMatch(match_p)) {
            assert (match_p != null && match_p.isPartial());
            result = match_p.getElementPresenceDifference();
            if (result == null) {
                EObject immediateContainer;
                Role presenceRole = match_p.getUncoveredRole().opposite();
                IMatch ownerMatch = this.getComparison().getContainerOf(match_p, presenceRole);
                if (ownerMatch instanceof EMatch && !((immediateContainer = ((EMatch)ownerMatch).getReference()) instanceof Scenario) && EcoreUtil2.getFirstContainer((EObject)immediateContainer, (EClass)InteractionPackage.Literals.SCENARIO) == null) {
                    result = this.getComparison().newElementPresence(match_p, ownerMatch);
                    if (this.getComparison().isThreeWay() && !match_p.coversRole(Role.ANCESTOR)) {
                        ((IDifference.Editable)result).markAsDifferentFromAncestor();
                    }
                    this.setElementPresenceDependencies(result);
                }
            }
        }
        return result;
    }

    protected XMLPivotDiffPolicy getCastedDiffPolicy() {
        if (this.getDiffPolicy() instanceof XMLPivotDiffPolicy) {
            return (XMLPivotDiffPolicy)this.getDiffPolicy();
        }
        return null;
    }

    protected void createAllAttributeDifferences(IMatch match_p) {
        assert (match_p != null && !match_p.isPartial());
        EClass eClass = match_p.get(Role.TARGET).eClass();
        for (EAttribute attribute : eClass.getEAllAttributes()) {
            if (!this.getCastedDiffPolicy().coverFeature(match_p, (EStructuralFeature)attribute)) continue;
            this.createAttributeDifferences(match_p, attribute);
        }
    }

    protected void createAttributeDifferences(IMatch match_p, EAttribute attribute_p) {
        assert (match_p != null && !match_p.isPartial() && attribute_p != null);
        IEditableModelScope targetScope = this.getComparison().getScope(Role.TARGET);
        IEditableModelScope referenceScope = this.getComparison().getScope(Role.REFERENCE);
        EObject target = match_p.get(Role.TARGET);
        EObject reference = match_p.get(Role.REFERENCE);
        List targetValues = targetScope.get(target, attribute_p);
        List referenceValues = referenceScope.get(reference, attribute_p);
        ArrayList remainingTargetValues = new ArrayList(targetValues);
        ArrayList remainingReferenceValues = new ArrayList(referenceValues);
        boolean checkOrder = attribute_p.isMany() && this.getCastedDiffPolicy().considerOrdered((EStructuralFeature)attribute_p);
        int maxIndex = -1;
        for (Object targetValue : targetValues) {
            DiffOperation.ObjectAndIndex matchingReferenceValue = this.findEqualAttributeValue(target, reference, attribute_p, targetValue, remainingReferenceValues);
            if (matchingReferenceValue.getObject() == null) continue;
            if (checkOrder) {
                if (matchingReferenceValue.getIndex() < maxIndex) {
                    this.createAttributeOrderDifference(match_p, attribute_p, targetValue, matchingReferenceValue.getObject());
                    checkOrder = false;
                } else {
                    maxIndex = matchingReferenceValue.getIndex();
                }
            }
            remainingTargetValues.remove(targetValue);
            remainingReferenceValues.remove(matchingReferenceValue.getObject());
        }
        for (Object remainingTargetValue : remainingTargetValues) {
            if (!this.getCastedDiffPolicy().coverValue(remainingTargetValue, attribute_p)) continue;
            this.createAttributeValueDifference(match_p, attribute_p, remainingTargetValue, Role.TARGET, false);
        }
        for (Object remainingReferenceValue : remainingReferenceValues) {
            if (!this.getCastedDiffPolicy().coverValue(remainingReferenceValue, attribute_p)) continue;
            this.createAttributeValueDifference(match_p, attribute_p, remainingReferenceValue, Role.REFERENCE, false);
        }
    }

    protected void setThreeWayProperties(IAttributeValuePresence presence_p) {
        EObject ancestorHolder = presence_p.getElementMatch().get(Role.ANCESTOR);
        if (ancestorHolder != null) {
            boolean aligned;
            EAttribute attribute = presence_p.getFeature();
            IEditableModelScope ancestorScope = this.getComparison().getScope(Role.ANCESTOR);
            assert (ancestorScope != null);
            List valuesInAncestor = ancestorScope.get(ancestorHolder, attribute);
            if (presence_p.isOrder()) {
                Role presenceRole = presence_p.getPresenceRole();
                List values = this.getComparison().getScope(presenceRole).get(presence_p.getElementMatch().get(presenceRole), presence_p.getFeature());
                int maxIndex = -1;
                aligned = true;
                for (Object value : values) {
                    DiffOperation.ObjectAndIndex matchingAncestorValue = this.findEqualAttributeValue(presence_p.getElementMatch().get(presenceRole), ancestorHolder, attribute, value, valuesInAncestor);
                    if (matchingAncestorValue.getObject() == null) continue;
                    if (matchingAncestorValue.getIndex() < maxIndex) {
                        aligned = false;
                        break;
                    }
                    maxIndex = matchingAncestorValue.getIndex();
                }
            } else {
                DiffOperation.ObjectAndIndex equalInAncestor = this.findEqualAttributeValue(presence_p.getElementMatch().get(presence_p.getPresenceRole()), ancestorHolder, attribute, presence_p.getValue(), valuesInAncestor);
                boolean bl = aligned = equalInAncestor.getObject() != null;
            }
            if (!aligned) {
                IAttributeValuePresence symmetrical = presence_p.getSymmetrical();
                if (symmetrical != null && !symmetrical.isAlignedWithAncestor()) {
                    ((IDifference.Editable)presence_p).markAsConflicting();
                    ((IDifference.Editable)symmetrical).markAsConflicting();
                } else {
                    ((IDifference.Editable)presence_p).markAsDifferentFromAncestor();
                }
            }
        }
    }

    protected DiffOperation.ObjectAndIndex findEqualAttributeValue(EObject holder1_p, EObject holder2_p, EAttribute attribute_p, Object value_p, Collection<? extends Object> candidates_p) {
        int i = 0;
        for (Object object : candidates_p) {
            if (this.considerEqual(holder1_p, holder2_p, value_p, object, attribute_p)) {
                return new DiffOperation.ObjectAndIndex(object, i);
            }
            ++i;
        }
        return new DiffOperation.ObjectAndIndex();
    }

    protected boolean considerEqual(EObject holder1_p, EObject holder2_p, Object value1_p, Object value2_p, EAttribute attribute_p) {
        if (SimplifiedCapellaMetadata.INSTANCE.isSemantic((EClassifier)holder1_p.eClass()) && SimplifiedCapellaMetadata.INSTANCE.isSemantic((EClassifier)holder2_p.eClass())) {
            return this.getCastedDiffPolicy().considerEqual(value1_p, value2_p, attribute_p);
        }
        return true;
    }
}

