/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import org.eclipse.cft.server.core.AbstractApplicationDelegate;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public abstract class ApplicationDelegate
extends AbstractApplicationDelegate {
    @Override
    public ApplicationDeploymentInfo getDefaultApplicationDeploymentInfo(IModule module, CloudFoundryServer cloudServer, IProgressMonitor monitor) throws CoreException {
        String appName = this.getCloudFoundryApplicationModule(module, cloudServer).getDeployedApplicationName();
        ApplicationDeploymentInfo deploymentInfo = new ApplicationDeploymentInfo(appName);
        deploymentInfo.setMemory(512);
        return deploymentInfo;
    }

    protected CloudFoundryApplicationModule getCloudFoundryApplicationModule(IModule module, CloudFoundryServer cloudServer) throws CoreException {
        CloudFoundryApplicationModule appModule = cloudServer.getExistingCloudModule(module);
        if (appModule == null) {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.ApplicationDelegate_NO_CLOUD_MODULE_FOUND, (Object)module.getName(), (Object)cloudServer.getServer().getId()));
        }
        return appModule;
    }

    @Override
    public IStatus validateDeploymentInfo(ApplicationDeploymentInfo deploymentInfo) {
        return CloudUtil.basicValidateDeploymentInfo(deploymentInfo);
    }

    @Override
    public ApplicationDeploymentInfo getExistingApplicationDeploymentInfo(IModule module, CloudFoundryServer cloudServer) throws CoreException {
        return CloudUtil.parseApplicationDeploymentInfo(this.getCloudFoundryApplicationModule(module, cloudServer).getApplication());
    }
}

