/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.io.IOException;
import java.net.URI;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.eclipse.cft.server.core.internal.client.AuthorizationHeaderProvider;
import org.eclipse.cft.server.core.internal.client.v2.CloudInfoV2;
import org.eclipse.cft.server.core.internal.client.v2.RestUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class V1ClientSupport {
    protected final AuthorizationHeaderProvider oauth;
    protected final RestTemplate restTemplate;
    protected final CloudInfoV2 cloudInfo;
    protected final String authorizationUrl;

    public V1ClientSupport(AuthorizationHeaderProvider oauth, CloudInfoV2 cloudInfo, boolean trustSelfSigned, HttpProxyConfiguration httpProxyConfiguration) {
        this.cloudInfo = cloudInfo;
        this.oauth = oauth;
        this.restTemplate = RestUtils.createRestTemplate(httpProxyConfiguration, trustSelfSigned, true);
        ClientHttpRequestFactory requestFactory = this.restTemplate.getRequestFactory();
        this.restTemplate.setRequestFactory(this.authorize(requestFactory));
        this.authorizationUrl = cloudInfo.getAuthorizationUrl();
    }

    protected ClientHttpRequestFactory authorize(final ClientHttpRequestFactory delegate) {
        return new ClientHttpRequestFactory(){

            public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
                ClientHttpRequest request = delegate.createRequest(uri, httpMethod);
                request.getHeaders().add("Authorization", V1ClientSupport.this.oauth.getAuthorizationHeader());
                return request;
            }
        };
    }

    protected String url(String path) {
        return String.valueOf(this.cloudInfo.getCloudControllerUrl()) + path;
    }
}

