/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.monitoring.lib.CComponentConstraintMonitor;
import org.eclipse.comma.monitoring.lib.CComponentConstraintResult;
import org.eclipse.comma.monitoring.lib.CComponentMonitoringContext;
import org.eclipse.comma.monitoring.lib.CComponentResults;
import org.eclipse.comma.monitoring.lib.CConnectionResults;
import org.eclipse.comma.monitoring.lib.CMessageInfo;
import org.eclipse.comma.monitoring.lib.CPathDescription;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public class CComponentMonitor {
    private List<CMessageInfo> eventQueue = new ArrayList<CMessageInfo>();
    private String componentInstance;
    private boolean inErrorState = false;
    private List<CComponentConstraintMonitor> monitors;
    private CComponentResults result;
    private CComponentResults resultPerEvent;

    public CComponentMonitor(CComponentMonitoringContext context) {
        this.componentInstance = context.getComponentInstanceName();
        this.monitors = context.getFactory().createComponentConstraintMonitors(context);
        this.result = new CComponentResults(this.componentInstance);
    }

    public void traceEnded() throws Exception {
        if (!this.inErrorState) {
            for (CMessageInfo mInfo : this.eventQueue) {
                for (CPathDescription pd : mInfo.getPathDescriptions()) {
                    if (pd.postStatesKnown()) continue;
                    pd.setActiveStatesAsPostStates();
                    pd.setPostStatesKnown();
                }
                for (CComponentConstraintMonitor monitor : this.monitors) {
                    monitor.consume(mInfo.getMessage(), mInfo.getPathDescriptions(), this.determinePort(mInfo.getMessage()));
                }
            }
        }
        for (CComponentConstraintMonitor monitor : this.monitors) {
            monitor.traceEnded();
            CComponentConstraintResult monResult = monitor.getResults();
            this.result.addConstraintErrors(monResult.getConstraintErrors());
            this.result.addFunctionalConstraintResults(monResult.getFunctionaConstraintResults());
        }
    }

    public CComponentResults getResults() {
        return this.result;
    }

    public CComponentResults getResultForLastEvent() {
        return this.resultPerEvent;
    }

    public void consume(CObservedMessage message, List<CPathDescription> pathDescriptions, String connection) throws Exception {
        if (this.inErrorState) {
            this.resultPerEvent = null;
            return;
        }
        this.resultPerEvent = new CComponentResults(this.componentInstance);
        CMessageInfo messageInfo = new CMessageInfo(message, pathDescriptions, connection);
        if (messageInfo.isComplete() && this.eventQueue.isEmpty()) {
            for (CComponentConstraintMonitor monitor : this.monitors) {
                monitor.consume(message, pathDescriptions, this.determinePort(message));
                CComponentConstraintResult r = monitor.getResultForLastEvent();
                if (r == null) continue;
                this.resultPerEvent.addConstraintErrors(r.getConstraintErrors());
                this.resultPerEvent.addFunctionalConstraintResults(r.getFunctionaConstraintResults());
            }
        } else {
            this.resolveIncompletePaths(messageInfo);
            this.flushQueue();
        }
    }

    private String determinePort(CObservedMessage message) {
        if (message.getSource().equals(this.componentInstance)) {
            return message.getSourcePort();
        }
        if (message.getDestination().equals(this.componentInstance)) {
            return message.getDestinationPort();
        }
        return null;
    }

    public void connectionError(CConnectionResults connectionResult) {
        this.inErrorState = true;
        this.result.addConnectionResult(connectionResult);
    }

    public void connectionError() {
        this.inErrorState = true;
    }

    public void connectionMonitoringDone(CConnectionResults connectionResult) {
        this.result.addConnectionResult(connectionResult);
    }

    public boolean inErrorState() {
        return this.inErrorState;
    }

    private void resolveIncompletePaths(CMessageInfo messageInfo) {
        for (CMessageInfo mInfo : this.eventQueue) {
            if (!mInfo.isSameConnection(messageInfo) || mInfo.isComplete()) continue;
            mInfo.resolvePostEventStates(messageInfo.getPathDescriptions());
            break;
        }
        this.eventQueue.add(messageInfo);
    }

    private void flushQueue() throws Exception {
        while (!this.eventQueue.isEmpty() && this.eventQueue.get(0).isComplete()) {
            for (CComponentConstraintMonitor monitor : this.monitors) {
                monitor.consume(this.eventQueue.get(0).getMessage(), this.eventQueue.get(0).getPathDescriptions(), this.determinePort(this.eventQueue.get(0).getMessage()));
                CComponentConstraintResult r = monitor.getResultForLastEvent();
                if (r == null) continue;
                this.resultPerEvent.addConstraintErrors(r.getConstraintErrors());
                this.resultPerEvent.addFunctionalConstraintResults(r.getFunctionaConstraintResults());
            }
            this.eventQueue.remove(0);
        }
    }
}

