/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.runner;

import org.eclipse.jdt.internal.junit.runner.FailedComparison;
import org.eclipse.jdt.internal.junit.runner.IListensToTestExecutions;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.MessageSender;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.jdt.internal.junit.runner.TestIdMap;
import org.eclipse.jdt.internal.junit.runner.TestReferenceFailure;

public class FirstRunExecutionListener
implements IListensToTestExecutions {
    protected MessageSender fSender;
    private TestIdMap fIds;

    FirstRunExecutionListener(MessageSender sender, TestIdMap ids) {
        this.fSender = sender;
        if (ids == null) {
            throw new NullPointerException();
        }
        this.fIds = ids;
    }

    @Override
    public void notifyTestEnded(ITestIdentifier test) {
        this.sendMessage(test, "%TESTE  ");
        this.fSender.flush();
    }

    @Override
    public void notifyTestFailed(TestReferenceFailure failure) {
        this.sendMessage(failure.getTest(), failure.getStatus());
        this.sendFailure(failure, "%TRACES ", "%TRACEE ");
    }

    @Override
    public void notifyTestStarted(ITestIdentifier test) {
        this.sendMessage(test, "%TESTS  ");
        this.fSender.flush();
    }

    private String getTestId(ITestIdentifier test) {
        return this.fIds.getTestId(test);
    }

    protected void sendFailure(TestReferenceFailure failure, String startTrace, String endTrace) {
        FailedComparison comparison = failure.getComparison();
        if (comparison != null) {
            comparison.sendMessages(this.fSender);
        }
        this.fSender.sendMessage(startTrace);
        this.fSender.sendMessage(failure.getTrace());
        this.fSender.sendMessage(endTrace);
        this.fSender.flush();
    }

    private void sendMessage(ITestIdentifier test, String status) {
        this.fSender.sendMessage(String.valueOf(status) + this.getTestId(test) + ',' + RemoteTestRunner.escapeText(test.getName()));
    }
}

