/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameStrategy;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Strings;

public class DefaultRenameStrategy
extends AbstractRenameStrategy {
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private IValueConverterService valueConverterService;
    protected ITextRegion originalNameRegion;
    protected String nameRuleName;

    @Override
    public boolean initialize(EObject targetElement, IRenameElementContext context) {
        if (super.initialize(targetElement, context)) {
            this.originalNameRegion = this.getOriginalNameRegion(targetElement, this.getNameAttribute());
            this.nameRuleName = this.getNameRuleName(targetElement, this.getNameAttribute());
            return true;
        }
        return false;
    }

    @Override
    public RefactoringStatus validateNewName(String newName) {
        RefactoringStatus status = super.validateNewName(newName);
        if (this.nameRuleName != null) {
            try {
                String value = this.getNameAsValue(newName);
                String text = this.getNameAsText(value);
                if (!Strings.equal((String)text, (String)newName)) {
                    status.addError("Illegal name: '" + newName + "'. Consider using '" + text + "' instead.");
                }
            }
            catch (ValueConverterException vce) {
                status.addFatalError("Illegal name: " + Strings.notNull((Object)vce.getMessage()));
            }
        }
        return status;
    }

    protected ITextRegion getOriginalNameRegion(EObject targetElement, EAttribute nameAttribute) {
        return this.locationInFileProvider.getFullTextRegion(targetElement, (EStructuralFeature)nameAttribute, 0);
    }

    protected String getNameRuleName(EObject targetElement, EAttribute nameAttribute) {
        AbstractRule nameRule;
        EObject grammarElement;
        List nameNodes = NodeModelUtils.findNodesForFeature((EObject)targetElement, (EStructuralFeature)nameAttribute);
        if (nameNodes.size() == 1 && (grammarElement = ((INode)nameNodes.get(0)).getGrammarElement()) instanceof RuleCall && (nameRule = ((RuleCall)grammarElement).getRule()) != null) {
            return nameRule.getName();
        }
        return null;
    }

    @Override
    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        updateAcceptor.accept(this.getTargetElementOriginalURI().trimFragment(), this.getDeclarationTextEdit(newName));
    }

    protected TextEdit getDeclarationTextEdit(String newName) {
        String text = newName;
        return new ReplaceEdit(this.originalNameRegion.getOffset(), this.originalNameRegion.getLength(), text);
    }

    protected String getNameAsText(String nameAsValue) {
        return this.nameRuleName != null ? this.getNameAsText(nameAsValue, this.nameRuleName) : nameAsValue;
    }

    protected String getNameAsText(String nameAsValue, String nameRuleName) {
        return nameRuleName != null ? this.valueConverterService.toString((Object)nameAsValue, nameRuleName) : nameAsValue;
    }

    protected String getNameAsValue(String nameAsText) {
        return this.nameRuleName != null ? this.getNameAsValue(nameAsText, this.nameRuleName) : nameAsText;
    }

    protected String getNameAsValue(String nameAsText, String nameRuleName) {
        return nameRuleName != null ? this.valueConverterService.toValue(nameAsText, nameRuleName, null).toString() : nameAsText;
    }

    @Override
    public String getOriginalName() {
        return this.getNameAsText(super.getOriginalName());
    }

    @Override
    public void applyDeclarationChange(String newName, ResourceSet resourceSet) {
        super.applyDeclarationChange(this.getNameAsValue(newName), resourceSet);
    }
}

