/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.context.impl.JobContextImpl;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.jsl.CloneUtility;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.ObjectFactory;
import com.ibm.jbatch.jsl.model.Partition;
import com.ibm.jbatch.jsl.model.PartitionPlan;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Split;
import com.ibm.jbatch.jsl.model.Step;

public class PartitionedStepBuilder {
    public static final String JOB_ID_SEPARATOR = ":";

    public static JSLJob buildFlowInSplitSubJob(JobContextImpl jobContext, Split split, Flow flow) {
        ObjectFactory jslFactory = new ObjectFactory();
        JSLJob subJob = jslFactory.createJSLJob();
        String subJobId = PartitionedStepBuilder.generateSubJobId((Long)jobContext.getInstanceId(), split.getId(), flow.getId());
        subJob.setId(subJobId);
        subJob.setProperties(CloneUtility.javaPropsTojslProperties(jobContext.getProperties()));
        subJob.getExecutionElements().add(flow);
        jobContext.addTopLevelContextProperties(subJob.getProperties());
        return subJob;
    }

    public static JSLJob buildPartitionSubJob(JobContextImpl jobContext, StepContextImpl stepCtx, Step step, int partitionInstance) {
        Partition partition;
        ObjectFactory jslFactory = new ObjectFactory();
        JSLJob subJob = jslFactory.createJSLJob();
        String subJobId = PartitionedStepBuilder.generateSubJobId((Long)jobContext.getInstanceId(), step.getId(), partitionInstance);
        subJob.setId(subJobId);
        subJob.setProperties(CloneUtility.javaPropsTojslProperties(jobContext.getProperties()));
        Step newStep = jslFactory.createStep();
        newStep.setId(step.getId());
        newStep.setAllowStartIfComplete(step.getAllowStartIfComplete());
        if (step.getBatchlet() != null) {
            newStep.setBatchlet(CloneUtility.cloneBatchlet(step.getBatchlet()));
        }
        if (step.getChunk() != null) {
            newStep.setChunk(CloneUtility.cloneChunk(step.getChunk()));
        }
        if ((partition = step.getPartition()) != null && partition.getCollector() != null) {
            Partition basePartition = jslFactory.createPartition();
            PartitionPlan partitionPlan = jslFactory.createPartitionPlan();
            partitionPlan.setPartitions(null);
            basePartition.setPlan(partitionPlan);
            basePartition.setCollector(partition.getCollector());
            newStep.setPartition(basePartition);
        }
        newStep.setStartLimit(step.getStartLimit());
        JSLProperties newProperties = CloneUtility.cloneJSLProperties(step.getProperties());
        if (newProperties == null) {
            newProperties = jslFactory.createJSLProperties();
        }
        Property jobName = jslFactory.createProperty();
        jobName.setName("com.ibm.jbatch.container.context.impl.StepContextImpl#getExecutionId");
        jobName.setValue(String.valueOf(stepCtx.getInternalStepExecutionId()));
        newProperties.getPropertyList().add(jobName);
        newStep.setProperties(newProperties);
        newStep.setListeners(CloneUtility.cloneListeners(step.getListeners()));
        subJob.getExecutionElements().add(newStep);
        jobContext.addTopLevelContextProperties(subJob.getProperties());
        return subJob;
    }

    private static String generateSubJobId(Long parentJobInstanceId, String splitId, String flowId) {
        StringBuilder strBuilder = new StringBuilder(JOB_ID_SEPARATOR);
        strBuilder.append(parentJobInstanceId.toString());
        strBuilder.append(JOB_ID_SEPARATOR);
        strBuilder.append(splitId);
        strBuilder.append(JOB_ID_SEPARATOR);
        strBuilder.append(flowId);
        return strBuilder.toString();
    }

    private static String generateSubJobId(Long parentJobInstanceId, String stepId, int partitionInstance) {
        StringBuilder strBuilder = new StringBuilder(JOB_ID_SEPARATOR);
        strBuilder.append(parentJobInstanceId.toString());
        strBuilder.append(JOB_ID_SEPARATOR);
        strBuilder.append(stepId);
        strBuilder.append(JOB_ID_SEPARATOR);
        strBuilder.append(partitionInstance);
        return strBuilder.toString();
    }
}

