/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.deployment.annotation.handlers;

import com.sun.enterprise.deployment.JMSDestinationDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.deployment.annotation.handlers.ResourceAnnotationControl;
import jakarta.jms.JMSDestinationDefinition;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.Set;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=JMSDestinationDefinition.class)
public class JMSDestinationDefinitionHandler
extends AbstractResourceHandler {
    private static final ResourceAnnotationControl CTRL = new ResourceAnnotationControl(JMSDestinationDefinition.class);

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        JMSDestinationDefinition jmsDestinationDefnAn = (JMSDestinationDefinition)ainfo.getAnnotation();
        return this.processAnnotation(jmsDestinationDefnAn, ainfo, rcContexts);
    }

    protected HandlerProcessingResult processAnnotation(JMSDestinationDefinition jmsDestinationDefnAn, AnnotationInfo aiInfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        Class annotatedClass = (Class)aiInfo.getAnnotatedElement();
        Annotation[] annotations = annotatedClass.getAnnotations();
        boolean warClass = this.isAWebComponentClass(annotations);
        boolean ejbClass = this.isAEjbComponentClass(annotations);
        for (ResourceContainerContext context : rcContexts) {
            JMSDestinationDefinitionDescriptor desc;
            if (!CTRL.canProcessAnnotation(annotatedClass, ejbClass, warClass, context)) {
                return this.getDefaultProcessedResult();
            }
            Set jmsddDescs = context.getResourceDescriptors(JavaEEResourceType.JMSDD);
            if (this.isDefinitionAlreadyPresent(jmsddDescs, desc = this.createDescriptor(jmsDestinationDefnAn))) {
                this.merge(jmsddDescs, jmsDestinationDefnAn);
                continue;
            }
            context.addResourceDescriptor((ResourceDescriptor)desc);
        }
        return this.getDefaultProcessedResult();
    }

    private boolean isDefinitionAlreadyPresent(Set<ResourceDescriptor> jmsddDescs, JMSDestinationDefinitionDescriptor desc) {
        for (ResourceDescriptor descriptor : jmsddDescs) {
            if (!descriptor.equals(desc)) continue;
            return true;
        }
        return false;
    }

    private void merge(Set<ResourceDescriptor> jmsddDescs, JMSDestinationDefinition defn) {
        for (ResourceDescriptor descriptor : jmsddDescs) {
            JMSDestinationDefinitionDescriptor desc;
            if (!(descriptor instanceof JMSDestinationDefinitionDescriptor) || !(desc = (JMSDestinationDefinitionDescriptor)descriptor).getName().equals(defn.name())) continue;
            if (desc.getInterfaceName() == null) {
                desc.setInterfaceName(defn.interfaceName());
            }
            if (desc.getClassName() == null && this.isValid(defn.className())) {
                desc.setClassName(defn.className());
            }
            if (desc.getDescription() == null && this.isValid(defn.description())) {
                desc.setDescription(defn.description());
            }
            if (desc.getResourceAdapter() == null && this.isValid(defn.resourceAdapter())) {
                desc.setResourceAdapter(defn.resourceAdapter());
            }
            if (desc.getDestinationName() == null && this.isValid(defn.destinationName())) {
                desc.setDestinationName(defn.destinationName());
            }
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length <= 0) break;
            for (String property : defnProperties) {
                int index = property.indexOf(61);
                if (index <= 0 || index >= property.length() - 1) continue;
                String name = property.substring(0, index).trim();
                String value = property.substring(index + 1).trim();
                if (properties.get(name) != null) continue;
                properties.put(name, value);
            }
        }
    }

    private JMSDestinationDefinitionDescriptor createDescriptor(JMSDestinationDefinition defn) {
        JMSDestinationDefinitionDescriptor desc = new JMSDestinationDefinitionDescriptor();
        desc.setMetadataSource(MetadataSource.ANNOTATION);
        desc.setName(defn.name());
        desc.setInterfaceName(defn.interfaceName());
        if (this.isValid(defn.className())) {
            desc.setClassName(defn.className());
        }
        if (this.isValid(defn.description())) {
            desc.setDescription(defn.description());
        }
        if (this.isValid(defn.resourceAdapter())) {
            desc.setResourceAdapter(defn.resourceAdapter());
        }
        if (this.isValid(defn.destinationName())) {
            desc.setDestinationName(defn.destinationName());
        }
        if (defn.properties() != null) {
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length > 0) {
                for (String property : defnProperties) {
                    int index = property.indexOf("=");
                    if (index <= 0 || index >= property.length() - 1) continue;
                    String name = property.substring(0, index).trim();
                    String value = property.substring(index + 1).trim();
                    properties.put(name, value);
                }
            }
        }
        return desc;
    }

    private boolean isValid(String s) {
        return s != null && !s.isEmpty();
    }
}

