/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.parser;

import com.sun.enterprise.server.logging.parser.LogParser;
import com.sun.enterprise.server.logging.parser.LogParserException;
import com.sun.enterprise.server.logging.parser.LogParserListener;
import com.sun.enterprise.server.logging.parser.ParsedLogRecord;
import java.io.BufferedReader;
import java.io.IOException;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OneLineLogParser
implements LogParser {
    private static final Pattern PATTERN = Pattern.compile("([0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T\\d\\d:\\d\\d:\\d\\d\\.[\\d]{3,9}([0-9:+-]{5,8}|Z)|\\d\\d:\\d\\d:\\d\\d\\.[\\d]{3,9})[ ]+([A-Z]+)[ ]+([\\S]+)[ ]+([\\S]*)(.*)");

    @Override
    public void parseLog(BufferedReader reader, LogParserListener listener) throws LogParserException {
        String line = null;
        try {
            long position = 0L;
            while ((line = reader.readLine()) != null) {
                ParsedLogRecord record = new ParsedLogRecord(line);
                Matcher matcher = PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                String timestamp = matcher.group(1);
                if (timestamp.length() > 18) {
                    record.setTimestamp(OffsetDateTime.parse(timestamp, ISO_OFFSET_DATE_TIME_PARSER));
                } else {
                    record.setTime(LocalTime.parse(timestamp, ISO_LOCAL_TIME_PARSER));
                }
                record.setLogLevel(matcher.group(3));
                record.setThreadName(matcher.group(4));
                record.setLogger(matcher.group(5));
                record.setMessage(matcher.group(6).trim());
                listener.foundLogRecord(position, record);
                ++position;
            }
        }
        catch (IOException e) {
            throw new LogParserException(line, e);
        }
    }
}

