/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.HiddenField;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.LogUtil;
import jakarta.el.ValueExpression;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;

public class Field
extends HiddenField
implements ComplexComponent,
NamingContainer {
    public static final String READONLY_ID = "_readOnly";
    public static final String LABEL_ID = "_label";
    public static final String INPUT_ID = "_field";
    public static final String READONLY_FACET = "readOnly";
    public static final String LABEL_FACET = "label";
    private static final boolean DEBUG = false;
    private int columns = Integer.MIN_VALUE;
    private boolean columnsSet = false;
    private boolean disabled = false;
    private boolean disabledSet = false;
    private String label = null;
    private int labelLevel = Integer.MIN_VALUE;
    private boolean labelLevelSet = false;
    private int maxLength = Integer.MIN_VALUE;
    private boolean maxLengthSet = false;
    private String onBlur = null;
    private String onChange = null;
    private String onClick = null;
    private String onDblClick = null;
    private String onFocus = null;
    private String onKeyDown = null;
    private String onKeyPress = null;
    private String onKeyUp = null;
    private String onMouseDown = null;
    private String onMouseMove = null;
    private String onMouseOut = null;
    private String onMouseOver = null;
    private String onMouseUp = null;
    private String onSelect = null;
    private boolean readOnly = false;
    private boolean readOnlySet = false;
    private String style = null;
    private String styleClass = null;
    private int tabIndex = Integer.MIN_VALUE;
    private boolean tabIndexSet = false;
    private String toolTip = null;
    private boolean trim = false;
    private boolean trimSet = false;
    private boolean visible = false;
    private boolean visibleSet = false;

    public Field() {
        this.setRendererType("com.sun.webui.jsf.Field");
    }

    @Override
    public String getFamily() {
        return "com.sun.webui.jsf.Field";
    }

    @Override
    public boolean isRequired() {
        return super.isRequired();
    }

    @Override
    public Object getValue() {
        return super.getValue();
    }

    @Override
    public Object getText() {
        return this.getValue();
    }

    public UIComponent getLabelComponent(FacesContext context, String labelStyle) {
        UIComponent labelComponent = this.getFacet(LABEL_FACET);
        if (labelComponent != null) {
            return labelComponent;
        }
        String fieldLabel = this.getLabel();
        labelComponent = this.createLabel(fieldLabel, labelStyle, context);
        return labelComponent;
    }

    public UIComponent getReadOnlyComponent(FacesContext context) {
        UIComponent textComponent = this.getFacet(READONLY_FACET);
        if (textComponent != null) {
            return textComponent;
        }
        textComponent = this.createText(this.getReadOnlyValueString(context));
        return textComponent;
    }

    private UIComponent createLabel(String labelString, String labelStyle, FacesContext context) {
        if (labelString == null) {
            ComponentUtilities.removePrivateFacet((UIComponent)this, LABEL_FACET);
            return null;
        }
        Label fieldLabel = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, LABEL_FACET, true);
        if (fieldLabel == null) {
            fieldLabel = new Label();
            fieldLabel.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, LABEL_FACET));
            ComponentUtilities.putPrivateFacet((UIComponent)this, LABEL_FACET, (UIComponent)fieldLabel);
        }
        fieldLabel.setLabelLevel(this.getLabelLevel());
        fieldLabel.setStyleClass(labelStyle);
        fieldLabel.setText(labelString);
        if (!this.isReadOnly()) {
            fieldLabel.setFor(this.getClientId(context));
        }
        return fieldLabel;
    }

    private UIComponent createText(String content) {
        StaticText text = new StaticText();
        if (content == null || content.length() < 1) {
            text.setText("");
        } else {
            text.setText(content);
        }
        text.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, READONLY_FACET));
        text.setParent((UIComponent)this);
        return text;
    }

    @Override
    protected void log(String msg) {
        LogUtil.finest(Field.class.getName() + "::" + msg);
    }

    @Override
    public String getLabeledElementId(FacesContext context) {
        if (this.isReadOnly()) {
            return null;
        }
        String clntId = this.getClientId(context);
        UIComponent labelComp = this.getLabelComponent(context, null);
        if (labelComp == null) {
            return clntId;
        }
        return clntId.concat(INPUT_ID);
    }

    @Override
    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    @Override
    public String getPrimaryElementID(FacesContext context) {
        String clntId = this.getClientId(context);
        UIComponent labelComp = this.getLabelComponent(context, null);
        if (labelComp == null) {
            return clntId;
        }
        return clntId.concat(INPUT_ID);
    }

    @Override
    public ValueExpression getValueExpression(String name) {
        if (name.equals("text")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    @Override
    public void setValueExpression(String name, ValueExpression binding) {
        if (name.equals("text")) {
            super.setValueExpression("value", binding);
            return;
        }
        super.setValueExpression(name, binding);
    }

    public int getColumns() {
        int cols = 20;
        if (this.columnsSet) {
            cols = this.columns;
        } else {
            ValueExpression vb = this.getValueExpression("columns");
            if (vb != null) {
                Object result = vb.getValue(this.getFacesContext().getELContext());
                cols = result == null ? Integer.MIN_VALUE : (Integer)result;
            }
        }
        if (cols < 1) {
            cols = 20;
            this.setColumns(20);
        }
        return cols;
    }

    public void setColumns(int newColumns) {
        this.columns = newColumns;
        this.columnsSet = true;
    }

    @Override
    public boolean isDisabled() {
        if (this.disabledSet) {
            return this.disabled;
        }
        ValueExpression vb = this.getValueExpression("disabled");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    @Override
    public void setDisabled(boolean newDisabled) {
        this.disabled = newDisabled;
        this.disabledSet = true;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        ValueExpression vb = this.getValueExpression(LABEL_FACET);
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    public int getLabelLevel() {
        if (this.labelLevelSet) {
            return this.labelLevel;
        }
        ValueExpression vb = this.getValueExpression("labelLevel");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return 2;
    }

    public void setLabelLevel(int newLabelLevel) {
        this.labelLevel = newLabelLevel;
        this.labelLevelSet = true;
    }

    public int getMaxLength() {
        if (this.maxLengthSet) {
            return this.maxLength;
        }
        ValueExpression vb = this.getValueExpression("maxLength");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setMaxLength(int newMaxLength) {
        this.maxLength = newMaxLength;
        this.maxLengthSet = true;
    }

    public String getOnBlur() {
        if (this.onBlur != null) {
            return this.onBlur;
        }
        ValueExpression vb = this.getValueExpression("onBlur");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnBlur(String newOnBlur) {
        this.onBlur = newOnBlur;
    }

    public String getOnChange() {
        if (this.onChange != null) {
            return this.onChange;
        }
        ValueExpression vb = this.getValueExpression("onChange");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnChange(String newOnChange) {
        this.onChange = newOnChange;
    }

    public String getOnClick() {
        if (this.onClick != null) {
            return this.onClick;
        }
        ValueExpression vb = this.getValueExpression("onClick");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnClick(String newOnClick) {
        this.onClick = newOnClick;
    }

    public String getOnDblClick() {
        if (this.onDblClick != null) {
            return this.onDblClick;
        }
        ValueExpression vb = this.getValueExpression("onDblClick");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnDblClick(String newOnDblClick) {
        this.onDblClick = newOnDblClick;
    }

    public String getOnFocus() {
        if (this.onFocus != null) {
            return this.onFocus;
        }
        ValueExpression vb = this.getValueExpression("onFocus");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnFocus(String newOnFocus) {
        this.onFocus = newOnFocus;
    }

    public String getOnKeyDown() {
        if (this.onKeyDown != null) {
            return this.onKeyDown;
        }
        ValueExpression vb = this.getValueExpression("onKeyDown");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyDown(String newOnKeyDown) {
        this.onKeyDown = newOnKeyDown;
    }

    public String getOnKeyPress() {
        if (this.onKeyPress != null) {
            return this.onKeyPress;
        }
        ValueExpression vb = this.getValueExpression("onKeyPress");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyPress(String newOnKeyPress) {
        this.onKeyPress = newOnKeyPress;
    }

    public String getOnKeyUp() {
        if (this.onKeyUp != null) {
            return this.onKeyUp;
        }
        ValueExpression vb = this.getValueExpression("onKeyUp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyUp(String newOnKeyUp) {
        this.onKeyUp = newOnKeyUp;
    }

    public String getOnMouseDown() {
        if (this.onMouseDown != null) {
            return this.onMouseDown;
        }
        ValueExpression vb = this.getValueExpression("onMouseDown");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseDown(String newOnMouseDown) {
        this.onMouseDown = newOnMouseDown;
    }

    public String getOnMouseMove() {
        if (this.onMouseMove != null) {
            return this.onMouseMove;
        }
        ValueExpression vb = this.getValueExpression("onMouseMove");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseMove(String newOnMouseMove) {
        this.onMouseMove = newOnMouseMove;
    }

    public String getOnMouseOut() {
        if (this.onMouseOut != null) {
            return this.onMouseOut;
        }
        ValueExpression vb = this.getValueExpression("onMouseOut");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOut(String newOnMouseOut) {
        this.onMouseOut = newOnMouseOut;
    }

    public String getOnMouseOver() {
        if (this.onMouseOver != null) {
            return this.onMouseOver;
        }
        ValueExpression vb = this.getValueExpression("onMouseOver");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOver(String newOnMouseOver) {
        this.onMouseOver = newOnMouseOver;
    }

    public String getOnMouseUp() {
        if (this.onMouseUp != null) {
            return this.onMouseUp;
        }
        ValueExpression vb = this.getValueExpression("onMouseUp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseUp(String newOnMouseUp) {
        this.onMouseUp = newOnMouseUp;
    }

    public String getOnSelect() {
        if (this.onSelect != null) {
            return this.onSelect;
        }
        ValueExpression vb = this.getValueExpression("onSelect");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnSelect(String newOnSelect) {
        this.onSelect = newOnSelect;
    }

    public boolean isReadOnly() {
        if (this.readOnlySet) {
            return this.readOnly;
        }
        ValueExpression vb = this.getValueExpression(READONLY_FACET);
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setReadOnly(boolean newReadOnly) {
        this.readOnly = newReadOnly;
        this.readOnlySet = true;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public int getTabIndex() {
        if (this.tabIndexSet) {
            return this.tabIndex;
        }
        ValueExpression vb = this.getValueExpression("tabIndex");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setTabIndex(int newTabIndex) {
        this.tabIndex = newTabIndex;
        this.tabIndexSet = true;
    }

    @Override
    public void setText(Object newText) {
        this.setValue(newText);
    }

    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        ValueExpression vb = this.getValueExpression("toolTip");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setToolTip(String newToolTip) {
        this.toolTip = newToolTip;
    }

    public boolean isTrim() {
        if (this.trimSet) {
            return this.trim;
        }
        ValueExpression vb = this.getValueExpression("trim");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setTrim(boolean newTrim) {
        this.trim = newTrim;
        this.trimSet = true;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.columns = (Integer)values[1];
        this.columnsSet = (Boolean)values[2];
        this.disabled = (Boolean)values[3];
        this.disabledSet = (Boolean)values[4];
        this.label = (String)values[5];
        this.labelLevel = (Integer)values[6];
        this.labelLevelSet = (Boolean)values[7];
        this.maxLength = (Integer)values[8];
        this.maxLengthSet = (Boolean)values[9];
        this.onBlur = (String)values[10];
        this.onChange = (String)values[11];
        this.onClick = (String)values[12];
        this.onDblClick = (String)values[13];
        this.onFocus = (String)values[14];
        this.onKeyDown = (String)values[15];
        this.onKeyPress = (String)values[16];
        this.onKeyUp = (String)values[17];
        this.onMouseDown = (String)values[18];
        this.onMouseMove = (String)values[19];
        this.onMouseOut = (String)values[20];
        this.onMouseOver = (String)values[21];
        this.onMouseUp = (String)values[22];
        this.onSelect = (String)values[23];
        this.readOnly = (Boolean)values[24];
        this.readOnlySet = (Boolean)values[25];
        this.style = (String)values[26];
        this.styleClass = (String)values[27];
        this.tabIndex = (Integer)values[28];
        this.tabIndexSet = (Boolean)values[29];
        this.toolTip = (String)values[30];
        this.trim = (Boolean)values[31];
        this.trimSet = (Boolean)values[32];
        this.visible = (Boolean)values[33];
        this.visibleSet = (Boolean)values[34];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.columns, this.columnsSet ? Boolean.TRUE : Boolean.FALSE, this.disabled ? Boolean.TRUE : Boolean.FALSE, this.disabledSet ? Boolean.TRUE : Boolean.FALSE, this.label, this.labelLevel, this.labelLevelSet ? Boolean.TRUE : Boolean.FALSE, this.maxLength, this.maxLengthSet ? Boolean.TRUE : Boolean.FALSE, this.onBlur, this.onChange, this.onClick, this.onDblClick, this.onFocus, this.onKeyDown, this.onKeyPress, this.onKeyUp, this.onMouseDown, this.onMouseMove, this.onMouseOut, this.onMouseOver, this.onMouseUp, this.onSelect, this.readOnly ? Boolean.TRUE : Boolean.FALSE, this.readOnlySet ? Boolean.TRUE : Boolean.FALSE, this.style, this.styleClass, this.tabIndex, this.tabIndexSet ? Boolean.TRUE : Boolean.FALSE, this.toolTip, this.trim ? Boolean.TRUE : Boolean.FALSE, this.trimSet ? Boolean.TRUE : Boolean.FALSE, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }
}

