/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.Queue;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jms.management.server.DestinationNotification;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class DestinationManagerMonitor
extends MQMBeanReadOnly {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;
    private static String[] dstNotificationTypes;
    private static MBeanNotificationInfo[] notifs;

    public Integer getNumDestinations() {
        List l = DestinationUtil.getVisibleDestinations();
        return l.size();
    }

    public Long getNumMsgs() {
        DestinationManagerMonitor destinationManagerMonitor = this;
        return destinationManagerMonitor.DL.totalCount();
    }

    public Long getNumMsgsInDMQ() {
        Queue[] qs = DestinationList.getDMQ(null);
        Queue dmq = qs[0];
        return dmq.size();
    }

    public Long getTotalMsgBytes() {
        DestinationManagerMonitor destinationManagerMonitor = this;
        return destinationManagerMonitor.DL.totalBytes();
    }

    public Long getTotalMsgBytesInDMQ() {
        Queue[] qs = DestinationList.getDMQ(null);
        Queue dmq = qs[0];
        return dmq.byteSize();
    }

    public ObjectName[] getDestinations() throws MBeanException {
        List dests = DestinationUtil.getVisibleDestinations();
        if (dests.size() == 0) {
            return null;
        }
        ObjectName[] destONames = new ObjectName[dests.size()];
        for (int i = 0; i < dests.size(); ++i) {
            Destination d = (Destination)dests.get(i);
            try {
                ObjectName o;
                destONames[i] = o = MQObjectName.createDestinationMonitor(d.isQueue() ? "q" : "t", d.getDestinationName());
                continue;
            }
            catch (Exception e) {
                this.handleOperationException("getDestinations", e);
            }
        }
        return destONames;
    }

    @Override
    public String getMBeanName() {
        return "DestinationManagerMonitor";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1191");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyDestinationCompact(Destination d) {
        DestinationNotification n = new DestinationNotification("mq.destination.compact", this, this.sequenceNumber++);
        n.setDestinationName(d.getDestinationName());
        n.setDestinationType(d.isQueue() ? "q" : "t");
        this.sendNotification(n);
    }

    public void notifyDestinationCreate(Destination d) {
        DestinationNotification n = new DestinationNotification("mq.destination.create", this, this.sequenceNumber++);
        boolean b = !d.isAutoCreated() && !d.isInternal() && !d.isDMQ() && !d.isAdmin();
        n.setDestinationName(d.getDestinationName());
        n.setDestinationType(d.isQueue() ? "q" : "t");
        n.setCreatedByAdmin(b);
        this.sendNotification(n);
    }

    public void notifyDestinationDestroy(Destination d) {
        DestinationNotification n = new DestinationNotification("mq.destination.destroy", this, this.sequenceNumber++);
        n.setDestinationName(d.getDestinationName());
        n.setDestinationType(d.isQueue() ? "q" : "t");
        this.sendNotification(n);
    }

    public void notifyDestinationPause(Destination d, String pauseType) {
        DestinationNotification n = new DestinationNotification("mq.destination.pause", this, this.sequenceNumber++);
        n.setDestinationName(d.getDestinationName());
        n.setDestinationType(d.isQueue() ? "q" : "t");
        n.setPauseType(pauseType);
        this.sendNotification(n);
    }

    public void notifyDestinationPurge(Destination d) {
        DestinationNotification n = new DestinationNotification("mq.destination.purge", this, this.sequenceNumber++);
        n.setDestinationName(d.getDestinationName());
        n.setDestinationType(d.isQueue() ? "q" : "t");
        this.sendNotification(n);
    }

    public void notifyDestinationResume(Destination d) {
        DestinationNotification n = new DestinationNotification("mq.destination.resume", this, this.sequenceNumber++);
        n.setDestinationName(d.getDestinationName());
        n.setDestinationType(d.isQueue() ? "q" : "t");
        this.sendNotification(n);
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[5];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumDestinations", Integer.class.getName(), mbr.getString("MB1175"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("NumMsgs", Long.class.getName(), mbr.getString("MB1176"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("NumMsgsInDMQ", Long.class.getName(), mbr.getString("MB1177"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("TotalMsgBytes", Long.class.getName(), mbr.getString("MB1178"), true, false, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("TotalMsgBytesInDMQ", Long.class.getName(), mbr.getString("MB1179"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[1];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getDestinations", mbr.getString("MB1190"), null, ObjectName[].class.getName(), 0);
        ops = mBeanOperationInfoArray;
        dstNotificationTypes = new String[]{"mq.destination.compact", "mq.destination.create", "mq.destination.destroy", "mq.destination.pause", "mq.destination.purge", "mq.destination.resume"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(dstNotificationTypes, DestinationNotification.class.getName(), mbr.getString("MB1133"));
        notifs = mBeanNotificationInfoArray;
    }
}

