/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQDualThreadService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

public class IMQDualThreadServiceFactory
extends ServiceFactory {
    protected static final Logger logger = Globals.getLogger();
    protected BrokerConfig props = Globals.getConfig();

    @Override
    public void checkFactoryHandlerName(String handlerName) throws IllegalAccessException {
        String myname = "mqdirect2";
        if (!myname.equals(handlerName)) {
            throw new IllegalAccessException("Unexpected service Handler name " + handlerName + ", expected " + myname);
        }
    }

    @Override
    public void updateService(Service s) throws BrokerException {
        IMQService ss = (IMQService)s;
        String name = s.getName();
        Globals.getPortMapper().addService(name, "none", this.props.getProperty("imq." + name + ".servicetype"), 0, ss.getServiceProperties());
    }

    @Override
    public void startMonitoringService(Service s) throws BrokerException {
    }

    @Override
    public void stopMonitoringService(Service s) throws BrokerException {
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
    }

    @Override
    public boolean update(String name, String value) {
        return true;
    }

    @Override
    public Service createService(String instancename, int type) throws BrokerException {
        if (DEBUG) {
            logger.log(4, " Creating new Service(" + instancename + ": Embedded )");
        }
        IMQDualThreadService svc = new IMQDualThreadService(instancename, type, Globals.getPacketRouter(type));
        return svc;
    }
}

