/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Locale;
import org.apache.catalina.ssi.SSICommand;
import org.apache.catalina.ssi.SSIMediator;
import org.apache.catalina.util.Strftime;
import org.glassfish.web.util.HtmlEntityEncoder;

public final class SSIFlastmod
implements SSICommand {
    @Override
    public long process(SSIMediator ssiMediator, String commandName, String[] paramNames, String[] paramValues, PrintWriter writer) {
        long lastModified = 0L;
        String configErrMsg = null;
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            String paramValue = paramValues[i];
            String substitutedValue = ssiMediator.substituteVariables(paramValue);
            try {
                if (paramName.equalsIgnoreCase("file") || paramName.equalsIgnoreCase("virtual")) {
                    boolean virtual = paramName.equalsIgnoreCase("virtual");
                    lastModified = ssiMediator.getFileLastModified(substitutedValue, virtual);
                    Date date = new Date(lastModified);
                    String configTimeFmt = ssiMediator.getConfigTimeFmt();
                    writer.write(this.formatDate(date, configTimeFmt));
                    continue;
                }
                ssiMediator.log("#flastmod--Invalid attribute: " + paramName);
                if (configErrMsg == null) {
                    configErrMsg = this.getEncodedConfigErrorMessage(ssiMediator);
                }
                writer.write(configErrMsg);
                continue;
            }
            catch (IOException e) {
                ssiMediator.log("#flastmod--Couldn't get last modified for file: " + substitutedValue, e);
                if (configErrMsg == null) {
                    configErrMsg = this.getEncodedConfigErrorMessage(ssiMediator);
                }
                writer.write(configErrMsg);
            }
        }
        return lastModified;
    }

    protected String formatDate(Date date, String configTimeFmt) {
        Strftime strftime = new Strftime(configTimeFmt, Locale.US);
        return strftime.format(date);
    }

    private String getEncodedConfigErrorMessage(SSIMediator ssiMediator) {
        String configErrMsg = ssiMediator.getConfigErrMsg();
        return HtmlEntityEncoder.encodeXSS((String)configErrMsg);
    }
}

