/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterInfoInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

public class ClusterInfoRequestInfo {
    public static final int STORE_SESSION_OWNER_TYPE = 1;
    public static final int PARTITION_ADDED_TYPE = 2;
    public static final String STORE_SESSION_PROP = "storeSession";
    public static final String STORE_SESSION_OWNER_PROP = "storeSessionOwner";
    public static final String PARTITION_PROP = "partition";
    private GPacket gp = null;
    private GPacket pkt = null;
    private Long xid = null;

    private ClusterInfoRequestInfo(Long xid) {
        this.xid = xid;
    }

    private ClusterInfoRequestInfo(GPacket pkt) {
        this.pkt = pkt;
    }

    public static ClusterInfoRequestInfo newInstance(Long xid) {
        return new ClusterInfoRequestInfo(xid);
    }

    public void storeSessionOwnerRequest(long storeSession) throws BrokerException {
        Integer v;
        if (this.gp == null) {
            this.gp = GPacket.getInstance();
            this.gp.setType((short)73);
            this.gp.putProp("X", this.xid);
        }
        if ((v = (Integer)this.gp.getProp("T")) == null) {
            this.gp.putProp("T", 1);
        } else {
            if ((v & 1) == 1) {
                throw new BrokerException("Internal Error: only 1 1 type info request is allowed");
            }
            int t = v | 1;
            this.gp.putProp("T", t);
        }
        this.gp.putProp(STORE_SESSION_PROP, storeSession);
    }

    public static ClusterInfoRequestInfo newInstance(GPacket pkt) {
        return new ClusterInfoRequestInfo(pkt);
    }

    public GPacket getGPacket() {
        return this.gp;
    }

    public ClusterInfoInfo getReply(int status, String reason, Object info) {
        assert (this.pkt != null);
        ClusterInfoInfo cii = ClusterInfoInfo.newInstance();
        if (ClusterInfoInfo.isStoreSessionOwnerInfo(this.pkt)) {
            cii.storeSessionOwnerRequestReply(this, status, reason, (String)info);
        }
        return cii;
    }

    public long getStoreSession() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp(STORE_SESSION_PROP);
    }

    public Long getXid() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp("X");
    }

    public String toString() {
        GPacket p;
        GPacket gPacket = p = this.pkt == null ? this.gp : this.pkt;
        if (p == null) {
            return "[]";
        }
        return "[requestType=" + String.valueOf(p.getProp("T")) + ", " + String.valueOf(p.propsEntrySet()) + "]";
    }
}

