/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsselector;

public class NumericValue {
    Number value = null;
    String image = null;
    int imageType = 0;
    private static final int ByteValue = 0;
    private static final int ShortValue = 1;
    private static final int IntValue = 2;
    private static final int FloatValue = 3;
    static final int LongValue = 4;
    static final int DoubleValue = 5;
    private static final int[][] returnTypes = new int[][]{{0, 1, 2, 3, 4, 5}, {1, 1, 2, 3, 4, 5}, {2, 2, 2, 3, 4, 5}, {3, 3, 3, 3, 3, 5}, {4, 4, 4, 3, 4, 5}, {5, 5, 5, 5, 5, 5}};

    public NumericValue(Object obj) {
        if (this.value != null && !(obj instanceof Number)) {
            throw new ClassCastException("Cannot make a NumericValue from a " + obj.getClass().getName());
        }
        if (obj instanceof NumericValue) {
            NumericValue n = (NumericValue)obj;
            this.value = n.value;
            this.image = n.image;
            this.imageType = n.imageType;
        } else {
            this.value = (Number)obj;
        }
    }

    public NumericValue(String image, int imageType) {
        this.image = image;
        this.imageType = imageType;
        this.value = null;
    }

    public Number getValue() {
        if (this.value == null && this.image != null) {
            switch (this.imageType) {
                case 5: {
                    this.value = Double.valueOf(this.image);
                    break;
                }
                case 4: {
                    this.value = Long.decode(this.image);
                    break;
                }
            }
            this.image = null;
            this.imageType = -1;
        }
        return this.value;
    }

    private int getIndexForType(Number obj) {
        int index = -1;
        Class<?> objClass = obj.getClass();
        if (objClass == Byte.class) {
            index = 0;
        } else if (objClass == Short.class) {
            index = 1;
        } else if (objClass == Integer.class) {
            index = 2;
        } else if (objClass == Float.class) {
            index = 3;
        } else if (objClass == Long.class) {
            index = 4;
        } else if (objClass == Double.class) {
            index = 5;
        } else {
            System.err.println("Unexpected failure in getIndexForType objClass=" + obj.getClass().getName());
        }
        return index;
    }

    int getUnifiedTypeIndex(Number val1, Number val2) {
        int index = -1;
        if (val1 != null && val2 != null) {
            int index1 = this.getIndexForType(val1);
            int index2 = this.getIndexForType(val2);
            index = returnTypes[index1][index2];
        }
        return index;
    }

    private Number convertNumber(Number val, int typeIndex) {
        switch (typeIndex) {
            case 0: {
                return val.byteValue();
            }
            case 1: {
                return val.shortValue();
            }
            case 2: {
                return val.intValue();
            }
            case 4: {
                return val.longValue();
            }
            case 5: {
                return val.doubleValue();
            }
        }
        return null;
    }

    public boolean between(NumericValue num1, NumericValue num2) {
        boolean result = false;
        if (this.getValue() != null && num1 != null && num2 != null) {
            int typeIndex2;
            Number value1 = num1.getValue();
            Number value2 = num2.getValue();
            int typeIndex1 = this.getUnifiedTypeIndex(this.value, value1);
            int typeIndex = typeIndex1 >= (typeIndex2 = this.getUnifiedTypeIndex(this.value, value2)) ? typeIndex1 : typeIndex2;
            Number val = this.convertNumber(this.value, typeIndex);
            Number val1 = this.convertNumber(value1, typeIndex);
            Number val2 = this.convertNumber(value2, typeIndex);
            switch (typeIndex) {
                case 0: {
                    result = val.byteValue() >= val1.byteValue() && val.byteValue() <= val2.byteValue() || val.byteValue() <= val1.byteValue() && val.byteValue() >= val2.byteValue();
                    break;
                }
                case 1: {
                    result = val.shortValue() >= val1.shortValue() && val.shortValue() <= val2.shortValue() || val.shortValue() <= val1.shortValue() && val.shortValue() >= val2.shortValue();
                    break;
                }
                case 2: {
                    result = val.intValue() >= val1.intValue() && val.intValue() <= val2.intValue() || val.intValue() <= val1.intValue() && val.intValue() >= val2.intValue();
                    break;
                }
                case 3: {
                    result = val.floatValue() >= val1.floatValue() && val.floatValue() <= val2.floatValue() || val.floatValue() <= val1.floatValue() && val.floatValue() >= val2.floatValue();
                    break;
                }
                case 4: {
                    result = val.longValue() >= val1.longValue() && val.longValue() <= val2.longValue() || val.longValue() <= val1.longValue() && val.longValue() >= val2.longValue();
                    break;
                }
                case 5: {
                    result = val.doubleValue() >= val1.doubleValue() && val.doubleValue() <= val2.doubleValue() || val.doubleValue() <= val1.doubleValue() && val.doubleValue() >= val2.doubleValue();
                    break;
                }
            }
        }
        return result;
    }

    public Number add(NumericValue num) {
        Number result = null;
        if (this.getValue() != null && num != null) {
            Number value2 = num.getValue();
            int typeIndex = this.getUnifiedTypeIndex(this.value, value2);
            Number val1 = this.convertNumber(this.value, typeIndex);
            Number val2 = this.convertNumber(value2, typeIndex);
            switch (typeIndex) {
                case 0: {
                    result = (byte)(val1.byteValue() + val2.byteValue());
                    break;
                }
                case 1: {
                    result = (short)(val1.shortValue() + val2.shortValue());
                    break;
                }
                case 2: {
                    result = val1.intValue() + val2.intValue();
                    break;
                }
                case 3: {
                    result = Float.valueOf(val1.floatValue() + val2.floatValue());
                    break;
                }
                case 4: {
                    result = val1.longValue() + val2.longValue();
                    break;
                }
                case 5: {
                    result = val1.doubleValue() + val2.doubleValue();
                    break;
                }
            }
        }
        return result;
    }

    public Number subtract(NumericValue num) {
        Number result = null;
        if (this.getValue() != null && num != null) {
            Number value2 = num.getValue();
            int typeIndex = this.getUnifiedTypeIndex(this.value, value2);
            Number val1 = this.convertNumber(this.value, typeIndex);
            Number val2 = this.convertNumber(value2, typeIndex);
            switch (typeIndex) {
                case 0: {
                    result = (byte)(val1.byteValue() - val2.byteValue());
                    break;
                }
                case 1: {
                    result = (short)(val1.shortValue() - val2.shortValue());
                    break;
                }
                case 2: {
                    result = val1.intValue() - val2.intValue();
                    break;
                }
                case 3: {
                    result = Float.valueOf(val1.floatValue() - val2.floatValue());
                    break;
                }
                case 4: {
                    result = val1.longValue() - val2.longValue();
                    break;
                }
                case 5: {
                    result = val1.doubleValue() - val2.doubleValue();
                    break;
                }
            }
        }
        return result;
    }

    public Number multiply(NumericValue num) {
        Number result = null;
        if (this.getValue() != null && num != null) {
            Number value2 = num.getValue();
            int typeIndex = this.getUnifiedTypeIndex(this.value, value2);
            Number val1 = this.convertNumber(this.value, typeIndex);
            Number val2 = this.convertNumber(value2, typeIndex);
            switch (typeIndex) {
                case 0: {
                    result = (byte)(val1.byteValue() * val2.byteValue());
                    break;
                }
                case 1: {
                    result = (short)(val1.shortValue() * val2.shortValue());
                    break;
                }
                case 2: {
                    result = val1.intValue() * val2.intValue();
                    break;
                }
                case 3: {
                    result = Float.valueOf(val1.floatValue() * val2.floatValue());
                    break;
                }
                case 4: {
                    result = val1.longValue() * val2.longValue();
                    break;
                }
                case 5: {
                    result = val1.doubleValue() * val2.doubleValue();
                    break;
                }
            }
        }
        return result;
    }

    public Number divide(NumericValue num) {
        Number result = null;
        if (this.getValue() != null && num != null) {
            Number value2 = num.getValue();
            int typeIndex = this.getUnifiedTypeIndex(this.value, value2);
            Number val1 = this.convertNumber(this.value, typeIndex);
            Number val2 = this.convertNumber(value2, typeIndex);
            switch (typeIndex) {
                case 0: {
                    result = (byte)(val1.byteValue() / val2.byteValue());
                    break;
                }
                case 1: {
                    result = (short)(val1.shortValue() / val2.shortValue());
                    break;
                }
                case 2: {
                    result = val1.intValue() / val2.intValue();
                    break;
                }
                case 3: {
                    result = Float.valueOf(val1.floatValue() / val2.floatValue());
                    break;
                }
                case 4: {
                    result = val1.longValue() / val2.longValue();
                    break;
                }
                case 5: {
                    result = val1.doubleValue() / val2.doubleValue();
                    break;
                }
            }
        }
        return result;
    }

    public Number negate() {
        Number result = null;
        if (this.image != null) {
            this.image = "-" + this.image;
            return this.getValue();
        }
        if (this.getValue() != null) {
            int typeIndex = this.getIndexForType(this.value);
            switch (typeIndex) {
                case 0: {
                    result = -this.value.byteValue();
                    break;
                }
                case 1: {
                    result = -this.value.shortValue();
                    break;
                }
                case 2: {
                    result = -this.value.intValue();
                    break;
                }
                case 3: {
                    result = Float.valueOf(-this.value.floatValue());
                    break;
                }
                case 4: {
                    result = -this.value.longValue();
                    break;
                }
                case 5: {
                    result = -this.value.doubleValue();
                    break;
                }
            }
        }
        return result;
    }

    public String toString() {
        String str = "null";
        if (this.getValue() != null) {
            str = this.value.toString();
        }
        return str;
    }
}

