/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.selector;

public class RegularExpression {
    String expression = null;
    Character escape = null;

    public RegularExpression(String expression, String escape) {
        this.expression = expression;
        if (escape != null) {
            this.escape = Character.valueOf(escape.charAt(0));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegularExpression)) {
            return false;
        }
        RegularExpression obj = (RegularExpression)o;
        return this.expression.equals(obj.expression) && this.escape.equals(obj.escape);
    }

    public String toString() {
        return "{re=" + this.expression + ", esc=" + this.escape + "}";
    }

    public String getExpression() {
        return this.expression;
    }

    public Character getEscape() {
        return this.escape;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean match(String string) {
        return this.match(this.expression, 0, string, 0);
    }

    private boolean match(String re, int reStart, String value, int valStart) {
        int reLen = re.length();
        int vLen = value.length();
        int i = reStart;
        int j = valStart;
        char esc = '\u0000';
        if (this.escape != null) {
            esc = this.escape.charValue();
        }
        boolean escaped = false;
        do {
            char c = re.charAt(i);
            if (this.escape != null && c == esc) {
                escaped = true;
                ++i;
                continue;
            }
            switch (c) {
                case '_': {
                    if (escaped) {
                        escaped = false;
                        if (c == value.charAt(j)) {
                            ++i;
                            ++j;
                            break;
                        }
                        return false;
                    }
                    ++i;
                    ++j;
                    break;
                }
                case '%': {
                    if (escaped) {
                        escaped = false;
                        if (c == value.charAt(j)) {
                            ++i;
                            ++j;
                            break;
                        }
                        return false;
                    }
                    if (++i == reLen) {
                        return true;
                    }
                    do {
                        if (!this.match(re, i, value, j)) continue;
                        return true;
                    } while (++j < vLen);
                    return false;
                }
                default: {
                    if (c == value.charAt(j)) {
                        ++i;
                        ++j;
                        escaped = false;
                        break;
                    }
                    return false;
                }
            }
        } while (j < vLen && i < reLen);
        while (i < reLen && re.charAt(i) == '%') {
            ++i;
        }
        return j == vLen && i == reLen;
    }
}

