/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.BasicQueue;
import com.sun.messaging.BasicTopic;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.zip.Compressor;
import com.sun.messaging.jmq.jmsclient.zip.Decompressor;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.util.net.IPAddress;
import com.sun.messaging.jms.Message;
import com.sun.messaging.jms.ra.ConvertValue;
import com.sun.messaging.jms.ra.DirectBytesPacket;
import com.sun.messaging.jms.ra.DirectMapPacket;
import com.sun.messaging.jms.ra.DirectObjectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import com.sun.messaging.jms.ra.DirectStreamPacket;
import com.sun.messaging.jms.ra.DirectTextPacket;
import com.sun.messaging.jms.ra.DirectXAResource;
import com.sun.messaging.jms.ra.TemporaryQueue;
import com.sun.messaging.jms.ra.TemporaryTopic;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectPacket
implements JMSPacket,
jakarta.jms.Message,
Message {
    protected Packet pkt = null;
    private SysMessageID receivedSysMessageID = null;
    private Hashtable<String, Object> properties = null;
    private long consumerId = 0L;
    private jakarta.jms.Destination jmsDestination = null;
    private jakarta.jms.Destination jmsReplyTo = null;
    private String jmsMessageID = null;
    private boolean jmsMessageIDSet = false;
    private boolean readOnlyBody = false;
    private boolean readOnlyProperties = false;
    private DirectSession ds = null;
    private boolean browserMessage = false;
    private static final String _className = "com.sun.messaging.jms.ra.DirectPacket";
    private static final String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final String _lgrNameJMSMessage = "jakarta.jms.Message.mqjmsra";
    protected static final Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final Logger _loggerJM = Logger.getLogger("jakarta.jms.Message.mqjmsra");
    private static final String _lgrMIDPrefix = "MQJMSRA_DM";
    protected static final String _lgrMID_EET = "MQJMSRA_DM1001: ";
    protected static final String _lgrMID_INF = "MQJMSRA_DM1101: ";
    protected static final String _lgrMID_WRN = "MQJMSRA_DM2001: ";
    protected static final String _lgrMID_ERR = "MQJMSRA_DM3001: ";
    protected static final String _lgrMID_EXC = "MQJMSRA_DM4001: ";
    protected static final int _logLevel;
    protected static final boolean _logFINE;
    protected static final String UTF8 = "UTF8";
    protected static final int DIRECT_PACKET_LOCAL_PORT = 1;
    private static final byte[] pktIPAddress;
    private static final byte[] pktMacAddress;
    protected boolean shouldCompress = false;
    protected int clientRetries = 0;
    public static final String JMS_SUN_COMPRESS = "JMS_SUN_COMPRESS";
    public static final String JMS_SUN_UNCOMPRESSED_SIZE = "JMS_SUN_UNCOMPRESSED_SIZE";
    public static final String JMS_SUN_COMPRESSED_SIZE = "JMS_SUN_COMPRESSED_SIZE";
    private boolean enableZip = Boolean.getBoolean("imq.zip.enable");

    public DirectPacket(DirectSession ds) throws JMSException {
        if (_logFINE) {
            Object[] params = new Object[2];
            params[0] = ds;
            _loggerOC.entering(_className, "constructor()", params);
        }
        this.ds = ds;
        this.pkt = new Packet();
        this._setDefaultValues();
    }

    public DirectPacket(JMSPacket jmsPacket, long consumerId, DirectSession ds) throws JMSException {
        if (jmsPacket != null) {
            this.pkt = jmsPacket.getPacket();
            this.consumerId = consumerId;
            this.ds = ds;
            try {
                this.properties = this.pkt.getProperties();
            }
            catch (Exception ex) {
                this.properties = null;
                ex.printStackTrace();
                String exerrmsg = "MQJMSRA_DM4001: DirectPacket:Constructor on deliver:Unable to get properties from JMSPacket.";
                JMSException jmse = new JMSException(exerrmsg);
                throw jmse;
            }
        } else {
            String exerrmsg = "MQJMSRA_DM4001: DirectPacket:Construct on deliver:Failed due to invalid JMSPacket.";
            JMSException jmse = new JMSException(exerrmsg);
            throw jmse;
        }
        this.setIntProperty(JMSService.JMSXProperties.JMSXDeliveryCount.toString(), jmsPacket.getPacket().getDeliveryCount());
        this.readOnlyProperties = true;
        this.readOnlyBody = true;
    }

    protected static jakarta.jms.Message constructMessage(JMSPacket jmsPacket, long consumerId, DirectSession ds, JMSService jmsservice, boolean browserMessage) throws JMSException {
        DirectPacket jmsMsg = null;
        boolean valid = true;
        Exception t = null;
        int pType = 0;
        try {
            pType = jmsPacket.getPacket().getPacketType();
            switch (pType) {
                case 6: {
                    jmsMsg = new DirectPacket(jmsPacket, consumerId, ds);
                    break;
                }
                case 2: {
                    jmsMsg = new DirectBytesPacket(jmsPacket, consumerId, ds);
                    break;
                }
                case 3: {
                    jmsMsg = new DirectMapPacket(jmsPacket, consumerId, ds);
                    break;
                }
                case 5: {
                    jmsMsg = new DirectObjectPacket(jmsPacket, consumerId, ds);
                    break;
                }
                case 4: {
                    jmsMsg = new DirectStreamPacket(jmsPacket, consumerId, ds);
                    break;
                }
                case 1: {
                    jmsMsg = new DirectTextPacket(jmsPacket, consumerId, ds);
                    break;
                }
                default: {
                    valid = false;
                    break;
                }
            }
        }
        catch (Exception e) {
            valid = false;
            t = e;
        }
        if (!valid) {
            String exerrmsg = "MQJMSRA_DM4001: DirectPacket:constructMessage():Failed on invalid PacketType=" + pType + (String)(t != null ? " due to Exception=" + t.getMessage() : "") + ".";
            JMSException jmse = new JMSException(exerrmsg);
            if (t != null) {
                jmse.initCause((Throwable)t);
            }
            throw jmse;
        }
        ((DirectPacket)jmsMsg).browserMessage = browserMessage;
        if (!browserMessage) {
            jmsMsg.setReceivedSysMessageID((SysMessageID)jmsPacket.getPacket().getSysMessageID().clone());
        }
        return jmsMsg;
    }

    protected static DirectPacket constructFromForeignMessage(JMSService jmsservice, DirectSession ds, jakarta.jms.Message foreignMessage) throws JMSException {
        String tkey;
        DirectPacket jmsMsg = null;
        if (foreignMessage instanceof TextMessage) {
            DirectTextPacket dtp = new DirectTextPacket(ds, ((TextMessage)foreignMessage).getText());
            jmsMsg = dtp;
        } else if (foreignMessage instanceof MapMessage) {
            DirectMapPacket dmp = new DirectMapPacket(ds);
            tkey = null;
            Enumeration keys = ((MapMessage)foreignMessage).getMapNames();
            while (keys.hasMoreElements()) {
                tkey = (String)keys.nextElement();
                dmp.setObject(tkey, ((MapMessage)foreignMessage).getObject(tkey));
            }
            jmsMsg = dmp;
        } else if (foreignMessage instanceof ObjectMessage) {
            DirectObjectPacket dop = new DirectObjectPacket(ds, ((ObjectMessage)foreignMessage).getObject());
            jmsMsg = dop;
        } else if (foreignMessage instanceof BytesMessage) {
            DirectBytesPacket dbp = new DirectBytesPacket(ds);
            ((BytesMessage)foreignMessage).reset();
            try {
                while (true) {
                    byte b = ((BytesMessage)foreignMessage).readByte();
                    dbp.writeByte(b);
                }
            }
            catch (MessageEOFException b) {
            }
            catch (Exception e) {
                String exerrmsg = "MQJMSRA_DM4001: DirectPacket:+constructFromForeignMessage():Failed on converting foreign BytesMessage due to Exception=" + e.getMessage();
                JMSException jmse = new JMSException(exerrmsg);
                jmse.initCause((Throwable)e);
                throw jmse;
            }
            jmsMsg = dbp;
        } else if (foreignMessage instanceof StreamMessage) {
            DirectStreamPacket dsp = new DirectStreamPacket(ds);
            ((StreamMessage)foreignMessage).reset();
            Object obj = null;
            try {
                while (true) {
                    obj = ((StreamMessage)foreignMessage).readObject();
                    dsp.writeObject(obj);
                }
            }
            catch (MessageEOFException exerrmsg) {
            }
            catch (Exception e) {
                String exerrmsg = "MQJMSRA_DM4001: DirectPacket:+constructFromForeignMessage():Failed on converting foreign StreamMessage due to Exception=" + e.getMessage();
                JMSException jmse = new JMSException(exerrmsg);
                jmse.initCause((Throwable)e);
                throw jmse;
            }
            jmsMsg = dsp;
        } else {
            DirectPacket dp;
            jmsMsg = dp = new DirectPacket(ds);
        }
        jmsMsg.setJMSCorrelationID(foreignMessage.getJMSCorrelationID());
        jmsMsg.setJMSType(foreignMessage.getJMSType());
        Enumeration keys = foreignMessage.getPropertyNames();
        tkey = null;
        Object tvalue = null;
        while (keys.hasMoreElements()) {
            tkey = (String)keys.nextElement();
            tvalue = foreignMessage.getObjectProperty(tkey);
            jmsMsg.setObjectProperty(tkey, tvalue);
        }
        return jmsMsg;
    }

    protected static void updateForeignMessageAfterSend(DirectPacket jmsPacket, jakarta.jms.Message foreignMessage) throws JMSException {
        foreignMessage.setJMSDeliveryMode(jmsPacket.getJMSDeliveryMode());
        foreignMessage.setJMSExpiration(jmsPacket.getJMSExpiration());
        Method m = null;
        try {
            Class c = foreignMessage.getClass();
            m = c.getMethod("getJMSDeliveryTime", null);
            if (Modifier.isAbstract(m.getModifiers())) {
                m = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (m != null && jmsPacket.getJMSDeliveryTime() != 0L) {
            foreignMessage.setJMSDeliveryTime(jmsPacket.getJMSDeliveryTime());
        }
        foreignMessage.setJMSPriority(jmsPacket.getJMSPriority());
        foreignMessage.setJMSTimestamp(jmsPacket.getJMSTimestamp());
        foreignMessage.setJMSMessageID(jmsPacket.getJMSMessageID());
        foreignMessage.setJMSDestination(jmsPacket.getJMSDestination());
    }

    @Override
    public Packet getPacket() {
        return this.pkt;
    }

    public jakarta.jms.Message getMessage() {
        return this;
    }

    protected SysMessageID getReceivedSysMessageID() {
        return this.receivedSysMessageID;
    }

    protected void setReceivedSysMessageID(SysMessageID sysMsgId) {
        this.receivedSysMessageID = sysMsgId;
    }

    public void acknowledge() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: acknowledge()");
        }
        if (this.browserMessage) {
            return;
        }
    }

    public void clearBody() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: clearBody()");
        }
        this.pkt.clearMessageBody();
        this._setReadOnlyBody(false);
    }

    public void clearProperties() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: clearProperties()");
        }
        this._setReadOnlyProperties(false);
        if (this.properties != null) {
            this.properties.clear();
        }
        this.shouldCompress = false;
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        if (_logFINE) {
            String methodName = "getBooleanProperty()";
            _loggerJM.fine(_lgrMID_INF + methodName + name);
        }
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ConvertValue.toBoolean(obj);
    }

    public byte getByteProperty(String name) throws JMSException {
        if (_logFINE) {
            String methodName = "getByteProperty()";
            _loggerJM.fine(_lgrMID_INF + methodName + name);
        }
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ConvertValue.toByte(obj);
    }

    public double getDoubleProperty(String name) throws JMSException {
        if (_logFINE) {
            String methodName = "getDoubleProperty()";
            _loggerJM.fine(_lgrMID_INF + methodName + name);
        }
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ConvertValue.toDouble(obj);
    }

    public float getFloatProperty(String name) throws JMSException {
        if (_logFINE) {
            String methodName = "getFloatProperty()";
            _loggerJM.fine(_lgrMID_INF + methodName + name);
        }
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ConvertValue.toFloat(obj);
    }

    public int getIntProperty(String name) throws JMSException {
        if (_logFINE) {
            String methodName = "getIntProperty()";
            _loggerJM.fine(_lgrMID_INF + methodName + name);
        }
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ConvertValue.toInt(obj);
    }

    public String getJMSCorrelationID() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSCorrelationID()");
        }
        return this.pkt.getCorrelationID();
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSCorrelationIDAsBytes()");
        }
        byte[] bytes = null;
        try {
            bytes = this.pkt.getCorrelationID().getBytes(UTF8);
        }
        catch (Exception e) {
            String exerrmsg = "MQJMSRA_DM4001: getJMSCorrelationIDAsBytes() failed :due to " + e.getMessage();
            JMSException jmse = new JMSException(exerrmsg);
            _loggerJM.severe(exerrmsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        return bytes;
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSDeliveryMode()=" + (this.pkt.getPersistent() ? 2 : 1));
        }
        if (this.pkt.getPersistent()) {
            return 2;
        }
        return 1;
    }

    public jakarta.jms.Destination getJMSDestination() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSDestination()");
        }
        String destName = null;
        String className = null;
        if (this.jmsDestination == null && (this.getReceivedSysMessageID() != null || this.browserMessage)) {
            try {
                destName = this.pkt.getDestination();
                className = this.pkt.getDestinationClass();
                this.jmsDestination = (Destination)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ((Destination)this.jmsDestination).setProperty("imqDestinationName", destName);
            }
            catch (Exception e) {
                this.jmsDestination = this._constructMQDestination(destName);
            }
        }
        return this.jmsDestination;
    }

    public long getJMSExpiration() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSExpiration()");
        }
        return this.pkt.getExpiration();
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSDeliveryTime()" + deliveryTime);
        }
        this.pkt.setDeliveryTime(deliveryTime);
    }

    public long getJMSDeliveryTime() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSJMSDeliveryTime()");
        }
        return this.pkt.getDeliveryTime();
    }

    public String getJMSMessageID() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSMessageID()");
        }
        if (this.jmsMessageIDSet) {
            return this.jmsMessageID;
        }
        return "ID:" + this.pkt.getMessageID();
    }

    public int getJMSPriority() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSPriority()");
        }
        return this.pkt.getPriority();
    }

    public boolean getJMSRedelivered() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSRedelivered()");
        }
        return this.pkt.getRedelivered();
    }

    public jakarta.jms.Destination getJMSReplyTo() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSReplyTo()");
        }
        String destName = null;
        String className = null;
        if (this.jmsReplyTo == null && (this.getReceivedSysMessageID() != null || this.browserMessage)) {
            if (this.pkt.getReplyTo() == null) {
                return null;
            }
            try {
                destName = this.pkt.getReplyTo();
                className = this.pkt.getReplyToClass();
                this.jmsReplyTo = (Destination)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ((Destination)this.jmsReplyTo).setProperty("imqDestinationName", destName);
            }
            catch (Exception e) {
                this.jmsReplyTo = this._constructMQDestination(destName);
            }
        }
        return this.jmsReplyTo;
    }

    public long getJMSTimestamp() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSTimestamp()");
        }
        return this.pkt.getTimestamp();
    }

    public String getJMSType() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: getJMSType()");
        }
        return this.pkt.getMessageType();
    }

    public long getLongProperty(String name) throws JMSException {
        if (_logFINE) {
            String methodName = "getLongProperty()";
            _loggerJM.fine(_lgrMID_INF + methodName + name);
        }
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ConvertValue.toLong(obj);
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (_logFINE) {
            String methodName = "getObjectProperty()";
            _loggerJM.fine(_lgrMID_INF + methodName + name);
        }
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (_logFINE) {
            String methodName = "getPropertyNames()";
            _loggerJM.fine(_lgrMID_INF + methodName);
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties.keys();
    }

    public short getShortProperty(String name) throws JMSException {
        if (_logFINE) {
            String methodName = "getShortProperty()";
            _loggerJM.fine(_lgrMID_INF + methodName + name);
        }
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ConvertValue.toShort(obj);
    }

    public String getStringProperty(String name) throws JMSException {
        Object obj;
        if (_logFINE) {
            String methodName = "getStringProperty()";
            _loggerJM.fine(_lgrMID_INF + methodName + name);
        }
        if (this.properties == null || (obj = this.properties.get(name)) == null) {
            return null;
        }
        return ConvertValue.toString(obj);
    }

    public boolean propertyExists(String name) throws JMSException {
        if (_logFINE) {
            String methodName = "propertyExists()";
            _loggerJM.fine(_lgrMID_INF + methodName + name);
        }
        if (this.properties == null) {
            return false;
        }
        try {
            return this.properties.containsKey(name);
        }
        catch (Exception e) {
            String exerrmsg = "MQJMSRA_DM4001: propertyExists() failed :due to " + e.getMessage();
            JMSException jmse = new JMSException(exerrmsg);
            _loggerJM.severe(exerrmsg);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this._checkAndSetProperty("setBooleanProperty()", name, value);
        if (JMS_SUN_COMPRESS.equals(name)) {
            this.shouldCompress = value;
        }
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this._checkAndSetProperty("setByteProperty()", name, value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this._checkAndSetProperty("setDoubleProperty()", name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this._checkAndSetProperty("setFloatProperty()", name, Float.valueOf(value));
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this._checkAndSetProperty("setIntProperty()", name, value);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        _loggerJM.fine("MQJMSRA_DM1101: setJMSCorrelationID()" + correlationID);
        this.pkt.setCorrelationID(correlationID);
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        if (_logFINE) {
            String methodName = "setJMSCorrelationIDAsBytes()";
            _loggerJM.fine(_lgrMID_INF + methodName + Arrays.toString(correlationID));
        }
        try {
            this.pkt.setCorrelationID(new String(correlationID, UTF8));
        }
        catch (Exception e) {
            String methodName = "setJMSCorrelationIDAsBytes()";
            String errMsg = _lgrMID_EXC + methodName + ":Caught Exception:" + methodName + ":" + e.getMessage();
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)e);
            _loggerJM.severe(errMsg);
            throw jmse;
        }
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        String methodName;
        if (_logFINE) {
            methodName = "setJMSDeliveryMode()";
            _loggerJM.fine(_lgrMID_INF + methodName + ":" + deliveryMode);
        }
        if (deliveryMode == 2) {
            this.pkt.setPersistent(true);
        } else if (deliveryMode == 1) {
            this.pkt.setPersistent(false);
        } else {
            methodName = "setJMSDeliveryMode()";
            String errMsg = _lgrMID_EXC + methodName + ":Invalid deliveryMode=" + deliveryMode;
            _loggerJM.severe(errMsg);
            throw new JMSException(errMsg);
        }
    }

    public void setJMSDestination(jakarta.jms.Destination destination) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSDestination()" + String.valueOf(destination));
        }
        this.jmsDestination = destination;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSExpiration()" + expiration);
        }
        if (expiration < 0L) {
            String errMsg = "MQJMSRA_DM4001: setJMSExpiration():Invalid expiration=" + expiration;
            _loggerJM.severe(errMsg);
            throw new JMSException(errMsg);
        }
        this.pkt.setExpiration(expiration);
    }

    public void setJMSMessageID(String id) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSMessageID()" + id);
        }
        this.jmsMessageIDSet = true;
        this.jmsMessageID = id;
    }

    public void setJMSPriority(int priority) throws JMSException {
        String methodName;
        if (_logFINE) {
            methodName = "setJMSPriority()";
            _loggerJM.fine(_lgrMID_INF + methodName + priority);
        }
        if (priority < 0 || priority > 9) {
            methodName = "setJMSPriority()";
            String errMsg = _lgrMID_EXC + methodName + ":Invalid priority=" + priority;
            _loggerJM.severe(errMsg);
            throw new JMSException(errMsg);
        }
        this.pkt.setPriority(priority);
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSRedelivered()" + redelivered);
        }
        this.pkt.setRedelivered(redelivered);
    }

    public void setJMSReplyTo(jakarta.jms.Destination replyTo) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSReplyTo()" + String.valueOf(replyTo));
        }
        this.jmsReplyTo = replyTo;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSTimestamp()" + timestamp);
        }
    }

    public void setJMSType(String type) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: setJMSType()" + type);
        }
        this.pkt.setMessageType(type);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this._checkAndSetProperty("setLongProperty()", name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this._checkAndSetProperty("setObjectProperty()", name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this._checkAndSetProperty("setShortProperty()", name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this._checkAndSetProperty("setStringProperty()", name, value);
    }

    @Override
    public void acknowledgeThisMessage() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: acknowledgeThisMessage()");
        }
        if (!this.browserMessage) {
            this.ds._acknowledgeThisMessage(this, this.consumerId, JMSService.MessageAckType.ACKNOWLEDGE);
        }
    }

    @Override
    public void acknowledgeUpThroughThisMessage() throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: acknowledge()");
        }
        this._unsupported("acknowledgeUpThroughThisMessage");
        if (this.consumerId != 0L) {
            this.ds._acknowledgeThisMessage(this, this.consumerId, JMSService.MessageAckType.ACKNOWLEDGE);
        }
    }

    protected void _setDefaultValues() throws JMSException {
        this.setJMSDeliveryMode(2);
        this.setJMSPriority(4);
        this.setJMSExpiration(0L);
        this.setJMSDeliveryTime(0L);
        if (pktMacAddress == null) {
            this.pkt.setIP(pktIPAddress);
        } else {
            this.pkt.setIP(pktIPAddress, pktMacAddress);
        }
        this.pkt.setPort(1);
        this.pkt.setPacketType(6);
    }

    protected void _setReadOnlyBody(boolean flag) {
        this.readOnlyBody = flag;
    }

    protected void _setReadOnlyProperties(boolean flag) {
        this.readOnlyProperties = flag;
    }

    protected void _resetJMSMessageID() {
        this.jmsMessageIDSet = false;
    }

    private jakarta.jms.Destination _constructMQDestination(String destName) throws JMSException {
        Destination dest = null;
        boolean isQ = this.pkt.getIsQueue();
        if (destName.startsWith("temporary_destination://queue/") || destName.startsWith("temporary_destination://" + String.valueOf((Object)Destination.Type.QUEUE))) {
            dest = new TemporaryQueue(destName);
            return dest;
        }
        if (destName.startsWith("temporary_destination://topic/") || destName.startsWith("temporary_destination://" + String.valueOf((Object)Destination.Type.TOPIC))) {
            dest = new TemporaryTopic(destName);
            return dest;
        }
        dest = isQ ? new BasicQueue(destName) : new BasicTopic(destName);
        return dest;
    }

    protected void _checkAndSetProperty(String methodName, String name, Object value) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine(_lgrMID_INF + methodName + ":name=" + name + ":value=" + String.valueOf(value));
        }
        if (name == null || "".equals(name)) {
            String errMsg = _lgrMID_EXC + methodName + ":name=" + name + ":value=" + String.valueOf(value) + ":IllegalArgument.";
            _loggerJM.severe(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        if (this.readOnlyProperties) {
            String errMsg = _lgrMID_EXC + methodName + ":name=" + name + ":value=" + String.valueOf(value) + ":Properties are Read Only.";
            _loggerJM.severe(errMsg);
            throw new MessageNotWriteableException(errMsg);
        }
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String)) {
            String errMsg = value == null ? _lgrMID_EXC + methodName + ":name=" + name + ":Bad property value: null" : _lgrMID_EXC + methodName + ":name=" + name + ":value=" + String.valueOf(value) + ":Bad type for property value=" + String.valueOf(value.getClass());
            _loggerJM.severe(errMsg);
            throw new MessageFormatException(errMsg);
        }
        this._checkValidPropertyName(methodName, name);
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(name, value);
    }

    protected void _checkValidPropertyName(String methodName, String name) throws JMSException {
        if ("NULL".equalsIgnoreCase(name) || "TRUE".equalsIgnoreCase(name) || "FALSE".equalsIgnoreCase(name) || "NOT".equalsIgnoreCase(name) || "AND".equalsIgnoreCase(name) || "OR".equalsIgnoreCase(name) || "BETWEEN".equalsIgnoreCase(name) || "LIKE".equalsIgnoreCase(name) || "IN".equalsIgnoreCase(name) || "IS".equalsIgnoreCase(name)) {
            String errMsg = _lgrMID_EXC + methodName + ":Illegal to use Reserved word as property name:" + name;
            _loggerJM.severe(errMsg);
            throw new JMSException(errMsg);
        }
        char[] namechars = name.toCharArray();
        if (Character.isJavaIdentifierStart(namechars[0])) {
            for (int i = 1; i < namechars.length; ++i) {
                if (Character.isJavaIdentifierPart(namechars[i])) continue;
                String errMsg = _lgrMID_EXC + methodName + ":Invalid character:'" + namechars[i] + "' used in property name:" + name;
                _loggerJM.severe(errMsg);
                throw new JMSException(errMsg);
            }
        } else {
            String errMsg = _lgrMID_EXC + methodName + ":Invalid start character:'" + namechars[0] + "' used in property name:" + name;
            _loggerJM.severe(errMsg);
            throw new JMSException(errMsg);
        }
    }

    protected void checkForReadOnlyMessageBody(String methodName) throws JMSException {
        if (this.readOnlyBody) {
            String errMsg = _lgrMID_EXC + methodName + ":Illegal to set JMS Message body when it is read only:";
            _loggerJM.severe(errMsg);
            throw new MessageNotWriteableException(errMsg);
        }
    }

    protected void checkForWriteOnlyMessageBody(String methodName) throws JMSException {
        if (!this.readOnlyBody) {
            String errMsg = _lgrMID_EXC + methodName + ":Illegal to read JMS Message body or length when it is write only:";
            _loggerJM.severe(errMsg);
            throw new MessageNotReadableException(errMsg);
        }
    }

    protected String _getJMSDestinationName() throws JMSException {
        if (this.jmsDestination instanceof Queue) {
            return ((Queue)this.jmsDestination).getQueueName();
        }
        if (this.jmsDestination instanceof Topic) {
            return ((Topic)this.jmsDestination).getTopicName();
        }
        return null;
    }

    protected String _getJMSReplyToName() throws JMSException {
        if (this.jmsReplyTo instanceof Queue) {
            return ((Queue)this.jmsReplyTo).getQueueName();
        }
        if (this.jmsReplyTo instanceof Topic) {
            return ((Topic)this.jmsReplyTo).getTopicName();
        }
        return null;
    }

    protected void _setConsumerId(long consumerId) {
        this.consumerId = consumerId;
    }

    protected long _getConsumerId() {
        return this.consumerId;
    }

    protected void preparePacketForSend() throws JMSException {
        long deliveryTime;
        if (this.enableZip) {
            this.compress();
        } else if (this.shouldCompress) {
            this.compress();
        } else {
            this.pkt.setFlag(1024, false);
        }
        this.pkt.setDestination(this._getJMSDestinationName());
        if (this.jmsDestination instanceof Queue) {
            this.pkt.setIsQueue(true);
        } else {
            this.pkt.setIsQueue(false);
        }
        this.pkt.setDestinationClass(this.jmsDestination.getClass().getName());
        if (this.jmsReplyTo != null && (this.jmsReplyTo instanceof Queue || this.jmsReplyTo instanceof Topic)) {
            this.pkt.setReplyTo(this._getJMSReplyToName());
            this.pkt.setReplyToClass(this.jmsReplyTo.getClass().getName());
        }
        this._setBodyToPacket();
        this.pkt.setProperties(this.properties);
        this.jmsMessageIDSet = false;
        this.pkt.prepareToSend();
        this._resetJMSMessageID();
        long expiration = this.getJMSExpiration();
        if (expiration != 0L) {
            this.setJMSExpiration(expiration += System.currentTimeMillis());
        }
        if ((deliveryTime = this.getJMSDeliveryTime()) != 0L) {
            this.setJMSDeliveryTime(deliveryTime += System.currentTimeMillis());
        }
    }

    protected void _setBodyToPacket() throws JMSException {
    }

    protected void _getMessageBodyFromPacket() throws JMSException {
    }

    protected void _setMessageBodyOfPacket(byte[] messageBody) {
        this.pkt.setMessageBody(messageBody);
    }

    protected void _setMessageBodyOfPacket(byte[] messageBody, int off, int len) {
        this.pkt.setMessageBody(messageBody, off, len);
    }

    protected byte[] _getMessageBodyByteArray() throws JMSException {
        if (this.pkt.getFlag(1024)) {
            this.decompress();
        }
        return this.pkt.getMessageBodyByteArray();
    }

    protected void _acknowledgeThisMessageForMDB(DirectXAResource dxar) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: acknowledgeThisMessageForMDB()");
        }
        this.ds._acknowledgeThisMessageForMDB(this, this.consumerId, JMSService.MessageAckType.ACKNOWLEDGE, dxar, this.getClientRetries());
    }

    protected void _acknowledgeThisMessageAsDeadForMDB(DirectXAResource dxar) throws JMSException {
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: acknowledgeThisMessageAsDeadForMDB()");
        }
        this.ds._acknowledgeThisMessageForMDB(this, this.consumerId, JMSService.MessageAckType.DEAD, dxar, this.getClientRetries());
    }

    private void _unsupported(String methodname) throws JMSException {
        String unsupported = "MQJMSRA_DM2001: messageId=" + this.pkt.getMessageID() + ":" + methodname;
        _loggerJM.warning(unsupported);
        throw new JMSException(unsupported);
    }

    protected void compress() throws JMSException {
        try {
            byte[] body = this.pkt.getMessageBodyByteArray();
            int offset = 0;
            int unzipSize = this.pkt.getMessageBodySize();
            if (body == null) {
                this.setIntProperty(JMS_SUN_UNCOMPRESSED_SIZE, 0);
                this.setIntProperty(JMS_SUN_COMPRESSED_SIZE, 0);
                return;
            }
            JMQByteArrayOutputStream baos = new JMQByteArrayOutputStream(new byte[32]);
            Compressor compressor = Compressor.getInstance();
            compressor.compress(body, offset, unzipSize, baos);
            baos.flush();
            byte[] zipbody = baos.getBuf();
            int zipSize = baos.getCount();
            baos.close();
            this.pkt.setMessageBody(zipbody, 0, zipSize);
            this.setIntProperty(JMS_SUN_UNCOMPRESSED_SIZE, unzipSize);
            this.setIntProperty(JMS_SUN_COMPRESSED_SIZE, zipSize);
            this.pkt.setFlag(1024, true);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            JMSException jmse = new JMSException(ioe.toString());
            jmse.setLinkedException(ioe);
            throw jmse;
        }
    }

    protected void decompress() throws JMSException {
        Decompressor decomp = Decompressor.getInstance();
        byte[] zipBody = this.pkt.getMessageBodyByteArray();
        int unzipSize = this.getIntProperty(JMS_SUN_UNCOMPRESSED_SIZE);
        byte[] unzipBody = new byte[unzipSize];
        decomp.decompress(zipBody, unzipBody);
        this.pkt.setMessageBody(unzipBody, 0, unzipSize);
        this.pkt.setFlag(1024, false);
        this.shouldCompress = true;
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        return MessageImpl._getBody(this, c);
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        return MessageImpl._isBodyAssignableTo(this, c);
    }

    public void updateDeliveryCount(int newDeliveryCount) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(JMSService.JMSXProperties.JMSXDeliveryCount.toString(), newDeliveryCount);
    }

    public int getClientRetries() {
        return this.clientRetries;
    }

    public void setClientRetries(int retryCount) {
        this.clientRetries = retryCount;
    }

    static {
        pktMacAddress = (byte[])(System.getProperty("imq.useMac", "true").equalsIgnoreCase("true") ? IPAddress.getRandomMac() : null);
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        pktIPAddress = addr == null ? null : addr.getAddress();
        Level _level = _loggerJM.getLevel();
        int tmplevel = Level.INFO.intValue();
        boolean tmplogfine = false;
        if (_level != null && (tmplevel = _level.intValue()) <= Level.FINE.intValue()) {
            tmplogfine = true;
        }
        _logLevel = tmplevel;
        _logFINE = tmplogfine;
    }
}

