/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cluster;

import com.sun.enterprise.util.cluster.Strings;
import java.util.List;

public final class NodeInfo {
    private final String host;
    private final String name;
    private final String installDir;
    private final String instancesList;
    private final String type;
    private static final String NAME = Strings.get("ListNode.name");
    private static final String TYPE = Strings.get("ListNode.type");
    private static final String HOST = Strings.get("ListNode.host");
    private static final String INSTALLDIR = Strings.get("ListNode.installDir");
    private static final String INSTANCESLIST = Strings.get("ListNode.instancesList");

    public NodeInfo(String name1, String host1, String installDir1, String type1, String instancesList1) {
        this.name = name1;
        this.host = host1;
        this.installDir = installDir1;
        this.type = type1;
        this.instancesList = instancesList1;
    }

    public final String getHost() {
        return this.host;
    }

    public final String getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final String getInstallDir() {
        return this.installDir;
    }

    public final String getInstancesList() {
        return this.instancesList;
    }

    public static String format(List<NodeInfo> infos) {
        int longestName = NAME.length();
        int longestType = TYPE.length();
        int longestInstallDir = INSTALLDIR.length();
        int longestHost = HOST.length();
        int longestInstancesList = INSTANCESLIST.length();
        int nullStringLen = 4;
        for (NodeInfo info : infos) {
            int instancesList1;
            int namel = info.getName().length();
            int hostl = info.getHost() != null ? info.getHost().length() : nullStringLen;
            int type1 = info.getType() != null ? info.getType().length() : nullStringLen;
            int installDir1 = info.getInstallDir() != null ? info.getInstallDir().length() : nullStringLen;
            int n = instancesList1 = info.getInstancesList() != null ? info.getInstancesList().length() : nullStringLen;
            if (namel > longestName) {
                longestName = namel;
            }
            if (hostl > longestHost) {
                longestHost = hostl;
            }
            if (type1 > longestType) {
                longestType = type1;
            }
            if (installDir1 > longestInstallDir) {
                longestInstallDir = installDir1;
            }
            if (instancesList1 <= longestInstancesList) continue;
            longestInstancesList = instancesList1;
        }
        StringBuilder sb = new StringBuilder();
        String formattedLine = "%-" + (longestName += 2) + "s %-" + (longestType += 2) + "s %-" + (longestHost += 2) + "s %-" + (longestInstallDir += 2) + "s %-" + (longestInstancesList += 2) + "s";
        sb.append(String.format(formattedLine, NAME, TYPE, HOST, INSTALLDIR, INSTANCESLIST));
        sb.append('\n');
        boolean first = true;
        for (NodeInfo info : infos) {
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(String.format(formattedLine, info.getName(), info.getType(), info.getHost(), info.getInstallDir(), info.getInstancesList()));
        }
        return sb.toString();
    }
}

