/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.EARBasedPersistenceHelper;
import com.sun.enterprise.deployment.archivist.ExtensionsArchivistFor;
import com.sun.enterprise.deployment.archivist.PersistenceArchivist;
import com.sun.enterprise.deployment.deploy.shared.MultiReadableArchive;
import com.sun.enterprise.deployment.util.DOLUtils;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXException;

@Service
@ExtensionsArchivistFor(value="jpa")
public class ACCPersistenceArchivist
extends PersistenceArchivist {
    @Inject
    private ProcessEnvironment env;
    @Inject
    private ArchiveFactory archiveFactory;

    @Override
    public boolean supportsModuleType(ArchiveType moduleType) {
        return Objects.equals(moduleType, DOLUtils.carType()) && this.env.getProcessType() == ProcessEnvironment.ProcessType.ACC;
    }

    @Override
    public RootDeploymentDescriptor open(Archivist main, ReadableArchive archive, RootDeploymentDescriptor descriptor) throws IOException, SAXException {
        deplLogger.logp(Level.FINE, "ACCPersistencerArchivist", "readPersistenceDeploymentDescriptors", "archive = {0}", archive.getURI());
        if (!(descriptor instanceof ApplicationClientDescriptor)) {
            return null;
        }
        HashMap<String, ReadableArchive> candidatePersistenceArchives = new HashMap<String, ReadableArchive>();
        ApplicationClientDescriptor acDescr = (ApplicationClientDescriptor)ApplicationClientDescriptor.class.cast(descriptor);
        Manifest mf = archive.getManifest();
        Attributes mainAttrs = mf.getMainAttributes();
        URI clientURI = this.clientURI(archive, acDescr);
        candidatePersistenceArchives.put(clientURI.toASCIIString(), archive);
        if (this.isDeployed(mainAttrs)) {
            if (!this.isDeployedClientAlsoStandAlone(mainAttrs)) {
                this.addOtherDeployedScanTargets(archive, mainAttrs, candidatePersistenceArchives);
            }
        } else if (!this.isStandAlone(acDescr)) {
            this.addOtherNondeployedScanTargets(archive, acDescr, candidatePersistenceArchives);
        }
        for (Map.Entry pathToArchiveEntry : candidatePersistenceArchives.entrySet()) {
            this.readPersistenceDeploymentDescriptor(main, (ReadableArchive)pathToArchiveEntry.getValue(), (String)pathToArchiveEntry.getKey(), descriptor);
        }
        return null;
    }

    private boolean isDeployedClientAlsoStandAlone(Attributes mainAttrs) {
        String relativePathToGroupFacade = mainAttrs.getValue(AppClientArchivist.GLASSFISH_GROUP_FACADE);
        return relativePathToGroupFacade == null;
    }

    private URI clientURI(ReadableArchive archive, ApplicationClientDescriptor acDesc) throws IOException {
        if (archive instanceof MultiReadableArchive) {
            Manifest facadeMF = archive.getManifest();
            Attributes facadeMainAttrs = facadeMF.getMainAttributes();
            URI clientRelativeURI = URI.create(facadeMainAttrs.getValue(AppClientArchivist.GLASSFISH_APPCLIENT));
            if (this.isDeployedClientAlsoStandAlone(facadeMainAttrs)) {
                return clientRelativeURI;
            }
            URI absURIToClient = ((MultiReadableArchive)archive).getURI(1);
            String relativeURIPathToAnchorDir = facadeMainAttrs.getValue(AppClientArchivist.GLASSFISH_ANCHOR_DIR);
            URI absURIToAnchorDir = archive.getURI().resolve(relativeURIPathToAnchorDir);
            return absURIToAnchorDir.relativize(absURIToClient);
        }
        return archive.getURI();
    }

    private boolean isStandAlone(ApplicationClientDescriptor ac) {
        return ac.getApplication() == null || ac.isStandalone();
    }

    private boolean isDeployed(Attributes mainAttrs) throws IOException {
        String gfClient = mainAttrs.getValue(AppClientArchivist.GLASSFISH_APPCLIENT);
        return gfClient != null;
    }

    private void addOtherDeployedScanTargets(ReadableArchive archive, Attributes mainAttrs, Map<String, ReadableArchive> candidates) throws IOException {
        String otherPUScanTargets = mainAttrs.getValue(AppClientArchivist.GLASSFISH_CLIENT_PU_SCAN_TARGETS_NAME);
        this.addScanTargetsFromURIList(archive, otherPUScanTargets, candidates);
    }

    private void addOtherNondeployedScanTargets(ReadableArchive clientArchive, ApplicationClientDescriptor acDescr, Map<String, ReadableArchive> candidates) {
        ReadableArchive earArchive = clientArchive.getParentArchive();
        EARBasedPersistenceHelper.addLibraryAndTopLevelCandidates(earArchive, acDescr.getApplication(), true, candidates);
    }

    private void addScanTargetsFromURIList(ReadableArchive archive, String relativeURIList, Map<String, ReadableArchive> candidates) throws IOException {
        String[] relativeURIs;
        if (relativeURIList == null || relativeURIList.isEmpty()) {
            return;
        }
        for (String uriText : relativeURIs = relativeURIList.split(" ")) {
            URI scanTargetURI = archive.getURI().resolve(uriText);
            candidates.put(uriText, this.archiveFactory.openArchive(scanTargetURI));
        }
    }
}

