/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.AdministeredObjectDefinitionDescriptor;
import com.sun.enterprise.deployment.ConnectionFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JMSConnectionFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.JMSDestinationDefinitionDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MailSessionDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.node.AdministeredObjectDefinitionNode;
import com.sun.enterprise.deployment.node.ConnectionFactoryDefinitionNode;
import com.sun.enterprise.deployment.node.DataSourceDefinitionNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;
import com.sun.enterprise.deployment.node.EjbReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerFactoryReferenceNode;
import com.sun.enterprise.deployment.node.EntityManagerReferenceNode;
import com.sun.enterprise.deployment.node.EnvEntryNode;
import com.sun.enterprise.deployment.node.JMSConnectionFactoryDefinitionNode;
import com.sun.enterprise.deployment.node.JMSDestinationDefinitionNode;
import com.sun.enterprise.deployment.node.JndiEnvRefNode;
import com.sun.enterprise.deployment.node.LifecycleCallbackNode;
import com.sun.enterprise.deployment.node.LocalizedInfoNode;
import com.sun.enterprise.deployment.node.MailSessionNode;
import com.sun.enterprise.deployment.node.MessageDestinationRefNode;
import com.sun.enterprise.deployment.node.ResourceEnvRefNode;
import com.sun.enterprise.deployment.node.ResourceRefNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.node.runtime.RuntimeBundleNode;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public abstract class DeploymentDescriptorNode<T extends Descriptor>
implements XMLNode<T> {
    private static final System.Logger LOG = DOLUtils.getLogger();
    private static final String QNAME_SEPARATOR = ":";
    private static final Map<Class<?>, Function<String, Object>> ALLOWED_DESCRIPTOR_INFO_CONVERSIONS = Map.of(String.class, String::valueOf, SimpleJndiName.class, SimpleJndiName::of, Integer.TYPE, Integer::valueOf, Long.TYPE, Long::valueOf, Boolean.TYPE, Boolean::valueOf);
    protected final ServiceLocator serviceLocator = Globals.getDefaultHabitat();
    protected Hashtable<String, Class<?>> handlers;
    private Hashtable<String, String> addMethods;
    private XMLElement xmlTag;
    private XMLNode<?> parentNode;
    protected T abstractDescriptor;

    public DeploymentDescriptorNode() {
        this.registerElementHandler(new XMLElement("description"), LocalizedInfoNode.class);
    }

    @Override
    public T getDescriptor() {
        if (this.abstractDescriptor == null) {
            this.abstractDescriptor = this.createDescriptor();
        }
        return this.abstractDescriptor;
    }

    protected T createDescriptor() {
        return DescriptorFactory.getDescriptor(this.getXMLPath());
    }

    @Override
    public void addDescriptor(Object descriptor) {
        if (this.getParentNode() == null) {
            throw new RuntimeException("Cannot add " + String.valueOf(descriptor) + " to " + this.toString());
        }
        this.getParentNode().addDescriptor(descriptor);
    }

    protected void addNodeDescriptor(DeploymentDescriptorNode node) {
        if (this.getDescriptor() == null) {
            this.addDescriptor(node.getDescriptor());
            return;
        }
        String xmlRootTag = node.getXMLRootTag().getQName();
        if (this.addMethods == null || !this.addMethods.containsKey(xmlRootTag)) {
            this.addDescriptor(node.getDescriptor());
            return;
        }
        try {
            String methodName = this.addMethods.get(xmlRootTag);
            Class<?> parameterType = node.getDescriptor().getClass();
            Method toInvoke = this.getCompatibleMethod(this.getDescriptor().getClass(), methodName, parameterType);
            toInvoke.invoke(this.getDescriptor(), node.getDescriptor());
        }
        catch (Exception t) {
            LOG.log(System.Logger.Level.ERROR, "enterprise.deployment.backend.addDescriptorFailure", node.getDescriptor().getClass(), this.getDescriptor().getClass());
            LOG.log(System.Logger.Level.ERROR, "Cause:", (Throwable)t);
        }
    }

    public void setParentNode(XMLNode<?> parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public XMLNode<?> getParentNode() {
        return this.parentNode;
    }

    @Override
    public XMLNode<?> getRootNode() {
        XMLNode<Object> parent = this;
        while (parent.getParentNode() != null) {
            parent = parent.getParentNode();
        }
        return parent;
    }

    protected final void registerElementHandler(XMLElement element, Class<?> handler) {
        if (this.handlers == null) {
            this.handlers = new Hashtable();
        }
        this.handlers.put(element.getQName(), handler);
    }

    public final void registerElementHandler(XMLElement element, Class<?> handler, String addMethodName) {
        this.registerElementHandler(element, handler);
        if (this.addMethods == null) {
            this.addMethods = new Hashtable();
        }
        this.addMethods.put(element.getQName(), addMethodName);
    }

    protected XMLElement getXMLRootTag() {
        return this.xmlTag;
    }

    protected void setXMLRootTag(XMLElement element) {
        this.xmlTag = element;
    }

    @Override
    public XMLNode<?> getHandlerFor(XMLElement element) {
        DeploymentDescriptorNode node;
        if (this.handlers == null) {
            LOG.log(System.Logger.Level.WARNING, "No handler registered in " + String.valueOf(this));
            return null;
        }
        Class<?> c = this.handlers.get(element.getQName());
        if (c == null) {
            LOG.log(System.Logger.Level.WARNING, "No class registered for " + element.getQName() + " in " + String.valueOf(this));
            return null;
        }
        LOG.log(System.Logger.Level.DEBUG, "New Handler requested for {0}", c);
        try {
            node = (DeploymentDescriptorNode)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            node.setParentNode(this);
            node.setXMLRootTag(element);
            node.getDescriptor();
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, "Error occurred", (Throwable)e);
            return null;
        }
        return node;
    }

    private Class<?> getExtensionHandler(XMLElement element) {
        DeploymentDescriptorNode extNode = (DeploymentDescriptorNode)this.serviceLocator.getService(XMLNode.class, element.getQName(), new Annotation[0]);
        if (extNode == null) {
            return null;
        }
        return extNode.getClass();
    }

    @Override
    public void startElement(XMLElement element, Attributes attributes) {
        if (!this.getXMLRootTag().equals(element)) {
            return;
        }
        if (attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getQName(i);
                String attrValue = attributes.getValue(i);
                LOG.log(System.Logger.Level.DEBUG, "With attribute {0} and value {1}", attrName, attrValue);
                if (this.setAttributeValue(element, new XMLElement(attrName), attrValue)) continue;
                this.setElementValue(new XMLElement(attrName), attrValue);
            }
        }
    }

    protected boolean setAttributeValue(XMLElement elementName, XMLElement attributeName, String value) {
        return attributeName.getQName().equals("id");
    }

    @Override
    public boolean endElement(XMLElement element) {
        boolean allDone = element.equals(this.getXMLRootTag());
        if (allDone) {
            this.postParsing();
            if (this.getParentNode() != null && this.getDescriptor() != null) {
                ((DeploymentDescriptorNode)this.getParentNode()).addNodeDescriptor(this);
            }
        }
        return allDone;
    }

    public void postParsing() {
    }

    @Override
    public boolean handlesElement(XMLElement element) {
        Class<?> extHandler;
        if (this.handlers != null) {
            Enumeration<String> handlersIterator = this.handlers.keys();
            while (handlersIterator.hasMoreElements()) {
                String subElement = handlersIterator.nextElement();
                if (!element.getQName().equals(subElement)) continue;
                this.recordNodeMapping(element.getQName(), this.handlers.get(subElement));
                return false;
            }
        }
        if ((extHandler = this.getExtensionHandler(element)) != null) {
            this.registerElementHandler(new XMLElement(element.getQName()), extHandler);
            this.recordNodeMapping(element.getQName(), extHandler);
            return false;
        }
        this.recordNodeMapping(element.getQName(), this.getClass());
        return true;
    }

    private void recordNodeMapping(String subElementName, Class<?> handler) {
        XMLNode<?> rootNode = this.getRootNode();
        if (rootNode instanceof RuntimeBundleNode) {
            ((RuntimeBundleNode)rootNode).recordNodeMapping(this.getXMLRootTag().getQName(), subElementName, handler);
        }
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        LOG.log(System.Logger.Level.DEBUG, "setElementValue(element={0}, value={1})", element, value);
        T descriptor = this.getDescriptor();
        if (descriptor == null) {
            throw new IllegalStateException("Descriptor not available in " + String.valueOf(this));
        }
        Map<String, String> dispatchTable = this.getDispatchTable();
        if (dispatchTable == null) {
            throw new IllegalStateException("Method dispatch table not available in " + String.valueOf(this));
        }
        String qName = element.getQName();
        String methodName = dispatchTable.get(qName);
        if (methodName == null) {
            LOG.log(System.Logger.Level.WARNING, "Deprecated element {0} with value {1} is ignored for descriptor {2} of node {3}.", element, value, descriptor.getClass(), this.getClass());
            LOG.log(System.Logger.Level.DEBUG, "Helpful stacktrace for the previous warning.", (Throwable)new RuntimeException());
            return;
        }
        try {
            this.setDescriptorInfo(descriptor, methodName, value);
        }
        catch (InvocationTargetException e) {
            LOG.log(System.Logger.Level.WARNING, "AS-DEPLOYMENT-00015", qName, value, descriptor.getClass());
            Throwable t = e.getCause();
            if (t instanceof IllegalArgumentException) {
                LOG.log(System.Logger.Level.WARNING, "AS-DEPLOYMENT-00015", qName, value, descriptor.getClass());
            }
            throw new IllegalArgumentException("Failed " + methodName + " when tried to set '" + value + "' to the descriptor " + String.valueOf(descriptor), e);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Failed " + methodName + " when tried to set '" + value + "' to the descriptor " + String.valueOf(descriptor), e);
        }
    }

    protected Map<String, String> getDispatchTable() {
        HashMap<String, String> table = new HashMap<String, String>();
        table.put("description", "setDescription");
        return table;
    }

    @Deprecated
    private void setDescriptorInfo(Object target, String methodName, String value) throws ReflectiveOperationException {
        LOG.log(System.Logger.Level.DEBUG, "setDescriptorInfo(target.class={0}, methodName={1}, value={2})", target.getClass(), methodName, value);
        ReflectiveOperationException e = new ReflectiveOperationException("Could not find compatible setter.");
        for (Map.Entry<Class<?>, Function<String, Object>> entry : ALLOWED_DESCRIPTOR_INFO_CONVERSIONS.entrySet()) {
            try {
                Method toInvoke = target.getClass().getMethod(methodName, entry.getKey());
                toInvoke.invoke(target, entry.getValue().apply(value));
                return;
            }
            catch (NumberFormatException nfe) {
                e.addSuppressed(nfe);
            }
            catch (NoSuchMethodException nsme) {
                e.addSuppressed(nsme);
            }
        }
        throw e;
    }

    @Override
    public String getXMLPath() {
        if (this.getParentNode() == null) {
            return this.getXMLRootTag().getQName();
        }
        return this.getParentNode().getXMLPath() + "/" + this.getXMLRootTag().getQName();
    }

    @Override
    public Node writeDescriptor(Node parent, T descriptor) {
        return this.writeDescriptor(parent, this.getXMLRootTag().getQName(), descriptor);
    }

    public Node writeDescriptor(Node parent, String nodeName, T descriptor) {
        return DeploymentDescriptorNode.appendChild(parent, nodeName);
    }

    public Node writeDescriptors(Node parent, String nodeName, Descriptor parentDesc) {
        return parent;
    }

    public Node writeSimpleTextDescriptor(Node parent, String nodeName, Descriptor parentDesc) {
        return parent;
    }

    public Node writeSubDescriptors(Node node, String nodeName, Descriptor descriptor) {
        LinkedHashMap<String, Class<?>> elementToNodeMappings;
        XMLNode<?> rootNode = this.getRootNode();
        if (rootNode instanceof RuntimeBundleNode && (elementToNodeMappings = ((RuntimeBundleNode)rootNode).getNodeMappings(nodeName)) != null) {
            Set<Map.Entry<String, Class<?>>> entrySet = elementToNodeMappings.entrySet();
            for (Map.Entry<String, Class<?>> entry : entrySet) {
                String subElementName = entry.getKey();
                if (subElementName.equals(nodeName)) continue;
                Class<?> handlerClass = entry.getValue();
                if (handlerClass.getName().equals(this.getClass().getName())) {
                    this.writeSimpleTextDescriptor(node, subElementName, descriptor);
                    continue;
                }
                try {
                    DeploymentDescriptorNode subNode = (DeploymentDescriptorNode)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    subNode.setParentNode(this);
                    subNode.writeDescriptors(node, subElementName, descriptor);
                }
                catch (Exception e) {
                    LOG.log(System.Logger.Level.WARNING, e.getMessage(), (Throwable)e);
                }
            }
        }
        return node;
    }

    protected static Document getOwnerDocument(Node node) {
        if (node instanceof Document) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static Element appendChild(Node parent, String elementName) {
        Element child = DeploymentDescriptorNode.getOwnerDocument(parent).createElement(elementName);
        parent.appendChild(child);
        return child;
    }

    public static Node appendTextChild(Node parent, String elementName, Object content) {
        if (content == null) {
            return null;
        }
        Element child = DeploymentDescriptorNode.appendChild(parent, elementName);
        child.appendChild(DeploymentDescriptorNode.getOwnerDocument(child).createTextNode(content.toString()));
        return child;
    }

    public static Node appendTextChild(Node parent, String elementName, String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        Element child = DeploymentDescriptorNode.appendChild(parent, elementName);
        child.appendChild(DeploymentDescriptorNode.getOwnerDocument(child).createTextNode(text));
        return child;
    }

    public static Node appendTextChild(Node parent, String elementName, int value) {
        return DeploymentDescriptorNode.appendTextChild(parent, elementName, String.valueOf(value));
    }

    public static Node forceAppendTextChild(Node parent, String elementName, String text) {
        Element child = DeploymentDescriptorNode.appendChild(parent, elementName);
        if (text != null && !text.isEmpty()) {
            child.appendChild(DeploymentDescriptorNode.getOwnerDocument(child).createTextNode(text));
        }
        return child;
    }

    public static void setAttribute(Element parent, String elementName, String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        parent.setAttribute(elementName, text);
    }

    public static void setAttributeNS(Element element, String prefix, String namespaceURI) {
        Object nsPrefix = prefix.isEmpty() ? "xmlns" : "xmlns:" + prefix;
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", (String)nsPrefix, namespaceURI);
    }

    protected void writeEnvEntryDescriptors(Node parentNode, Iterator envEntries) {
        if (envEntries == null || !envEntries.hasNext()) {
            return;
        }
        EnvEntryNode subNode = new EnvEntryNode();
        while (envEntries.hasNext()) {
            EnvironmentProperty envProp = (EnvironmentProperty)envEntries.next();
            subNode.writeDescriptor(parentNode, "env-entry", envProp);
        }
    }

    protected void writeEjbReferenceDescriptors(Node parentNode, Iterator<EjbReferenceDescriptor> refs) {
        if (refs == null || !refs.hasNext()) {
            return;
        }
        EjbReferenceNode subNode = new EjbReferenceNode();
        HashSet<EjbReferenceDescriptor> localRefDescs = new HashSet<EjbReferenceDescriptor>();
        while (refs.hasNext()) {
            EjbReferenceDescriptor ejbRef = refs.next();
            if (ejbRef.isLocal()) {
                localRefDescs.add(ejbRef);
                continue;
            }
            subNode.writeDescriptor(parentNode, "ejb-ref", ejbRef);
        }
        for (EjbReferenceDescriptor ejbRef : localRefDescs) {
            subNode.writeDescriptor(parentNode, "ejb-local-ref", ejbRef);
        }
    }

    protected void writeServiceReferenceDescriptors(Node parentNode, Iterator<ServiceReferenceDescriptor> refs) {
        if (refs == null || !refs.hasNext()) {
            return;
        }
        JndiEnvRefNode serviceRefNode = (JndiEnvRefNode)this.serviceLocator.getService(JndiEnvRefNode.class, "service-ref", new Annotation[0]);
        if (serviceRefNode != null) {
            while (refs.hasNext()) {
                ServiceReferenceDescriptor next = refs.next();
                serviceRefNode.writeDeploymentDescriptor(parentNode, next);
            }
        }
    }

    protected void writeResourceRefDescriptors(Node parentNode, Iterator resRefs) {
        if (resRefs == null || !resRefs.hasNext()) {
            return;
        }
        ResourceRefNode subNode = new ResourceRefNode();
        while (resRefs.hasNext()) {
            ResourceReferenceDescriptor aResRef = (ResourceReferenceDescriptor)resRefs.next();
            subNode.writeDescriptor(parentNode, "resource-ref", aResRef);
        }
    }

    protected void writeResourceEnvRefDescriptors(Node parentNode, Iterator<ResourceEnvReferenceDescriptor> resRefs) {
        if (resRefs == null || !resRefs.hasNext()) {
            return;
        }
        ResourceEnvRefNode subNode = new ResourceEnvRefNode();
        while (resRefs.hasNext()) {
            ResourceEnvReferenceDescriptor aResRef = resRefs.next();
            subNode.writeDescriptor(parentNode, "resource-env-ref", aResRef);
        }
    }

    protected void writeMessageDestinationRefDescriptors(Node parentNode, Iterator msgDestRefs) {
        if (msgDestRefs == null || !msgDestRefs.hasNext()) {
            return;
        }
        MessageDestinationRefNode subNode = new MessageDestinationRefNode();
        while (msgDestRefs.hasNext()) {
            MessageDestinationReferenceDescriptor next = (MessageDestinationReferenceDescriptor)msgDestRefs.next();
            subNode.writeDescriptor(parentNode, "message-destination-ref", next);
        }
    }

    protected void writeEntityManagerReferenceDescriptors(Node parentNode, Iterator entityMgrRefs) {
        if (entityMgrRefs == null || !entityMgrRefs.hasNext()) {
            return;
        }
        EntityManagerReferenceNode subNode = new EntityManagerReferenceNode();
        while (entityMgrRefs.hasNext()) {
            EntityManagerReferenceDescriptor aEntityMgrRef = (EntityManagerReferenceDescriptor)entityMgrRefs.next();
            subNode.writeDescriptor(parentNode, "persistence-context-ref", aEntityMgrRef);
        }
    }

    protected void writeEntityManagerFactoryReferenceDescriptors(Node parentNode, Iterator<EntityManagerFactoryReferenceDescriptor> entityMgrFactoryRefs) {
        if (entityMgrFactoryRefs == null || !entityMgrFactoryRefs.hasNext()) {
            return;
        }
        EntityManagerFactoryReferenceNode subNode = new EntityManagerFactoryReferenceNode();
        while (entityMgrFactoryRefs.hasNext()) {
            EntityManagerFactoryReferenceDescriptor aEntityMgrFactoryRef = entityMgrFactoryRefs.next();
            subNode.writeDescriptor(parentNode, "persistence-unit-ref", aEntityMgrFactoryRef);
        }
    }

    protected void writeLifeCycleCallbackDescriptors(Node parentNode, String tagName, Collection<LifecycleCallbackDescriptor> lifecycleCallbacks) {
        if (lifecycleCallbacks == null || lifecycleCallbacks.isEmpty()) {
            return;
        }
        LifecycleCallbackNode subNode = new LifecycleCallbackNode();
        for (LifecycleCallbackDescriptor lcd : lifecycleCallbacks) {
            subNode.writeDescriptor(parentNode, tagName, lcd);
        }
    }

    protected void writeResourceDescriptors(Node parentNode, Iterator<ResourceDescriptor> descriptorIterator) {
        if (descriptorIterator == null || !descriptorIterator.hasNext()) {
            return;
        }
        DataSourceDefinitionNode dataSourceDefinitionNode = new DataSourceDefinitionNode();
        MailSessionNode mailSessionNode = new MailSessionNode();
        ConnectionFactoryDefinitionNode connectionFactoryDefinitionNode = new ConnectionFactoryDefinitionNode();
        AdministeredObjectDefinitionNode administeredObjectDefinitionNode = new AdministeredObjectDefinitionNode();
        JMSConnectionFactoryDefinitionNode jmsConnectionFactoryDefinitionNode = new JMSConnectionFactoryDefinitionNode();
        JMSDestinationDefinitionNode jmsDestinationDefinitionNode = new JMSDestinationDefinitionNode();
        while (descriptorIterator.hasNext()) {
            ResourceDescriptor next;
            ResourceDescriptor descriptor = descriptorIterator.next();
            if (descriptor.getResourceType().equals((Object)JavaEEResourceType.DSD)) {
                next = (DataSourceDefinitionDescriptor)descriptor;
                dataSourceDefinitionNode.writeDescriptor(parentNode, "data-source", (DataSourceDefinitionDescriptor)next);
                continue;
            }
            if (descriptor.getResourceType().equals((Object)JavaEEResourceType.MSD)) {
                next = (MailSessionDescriptor)descriptor;
                mailSessionNode.writeDescriptor(parentNode, "mail-session", (MailSessionDescriptor)next);
                continue;
            }
            if (descriptor.getResourceType().equals((Object)JavaEEResourceType.CFD)) {
                next = (ConnectionFactoryDefinitionDescriptor)descriptor;
                connectionFactoryDefinitionNode.writeDescriptor(parentNode, "connection-factory", (ConnectionFactoryDefinitionDescriptor)next);
                continue;
            }
            if (descriptor.getResourceType().equals((Object)JavaEEResourceType.AODD)) {
                next = (AdministeredObjectDefinitionDescriptor)descriptor;
                administeredObjectDefinitionNode.writeDescriptor(parentNode, "administered-object", (AdministeredObjectDefinitionDescriptor)next);
                continue;
            }
            if (descriptor.getResourceType().equals((Object)JavaEEResourceType.JMSCFDD)) {
                next = (JMSConnectionFactoryDefinitionDescriptor)descriptor;
                jmsConnectionFactoryDefinitionNode.writeDescriptor(parentNode, "jms-connection-factory", (JMSConnectionFactoryDefinitionDescriptor)next);
                continue;
            }
            if (!descriptor.getResourceType().equals((Object)JavaEEResourceType.JMSDD)) continue;
            next = (JMSDestinationDefinitionDescriptor)descriptor;
            jmsDestinationDefinitionNode.writeDescriptor(parentNode, "jms-destination", (JMSDestinationDefinitionDescriptor)next);
        }
    }

    protected static void writeLocalizedDescriptions(Node node, Descriptor desc) {
        LocalizedInfoNode localizedNode = new LocalizedInfoNode();
        localizedNode.writeLocalizedMap(node, "description", desc.getLocalizedDescriptions());
    }

    protected void writeJNDIEnvironmentRefs(Node node, JndiNameEnvironment descriptor) {
        this.writeEnvEntryDescriptors(node, descriptor.getEnvironmentProperties().iterator());
        this.writeEjbReferenceDescriptors(node, descriptor.getEjbReferenceDescriptors().iterator());
        this.writeServiceReferenceDescriptors(node, descriptor.getServiceReferenceDescriptors().iterator());
        this.writeResourceRefDescriptors(node, descriptor.getResourceReferenceDescriptors().iterator());
        this.writeResourceEnvRefDescriptors(node, descriptor.getResourceEnvReferenceDescriptors().iterator());
        this.writeMessageDestinationRefDescriptors(node, descriptor.getMessageDestinationReferenceDescriptors().iterator());
        this.writeEntityManagerReferenceDescriptors(node, descriptor.getEntityManagerReferenceDescriptors().iterator());
        this.writeEntityManagerFactoryReferenceDescriptors(node, descriptor.getEntityManagerFactoryReferenceDescriptors().iterator());
        this.writeLifeCycleCallbackDescriptors(node, "post-construct", descriptor.getPostConstructDescriptors());
        this.writeLifeCycleCallbackDescriptors(node, "pre-destroy", descriptor.getPreDestroyDescriptors());
    }

    protected void addNamespaceDeclaration(Element node, Descriptor descriptor) {
        Map prefixMapping;
        Map map = prefixMapping = descriptor == null ? null : descriptor.getPrefixMapping();
        if (prefixMapping != null) {
            Set entrySet = prefixMapping.entrySet();
            for (Map.Entry entry : entrySet) {
                String prefix = (String)entry.getKey();
                String namespaceURI = (String)entry.getValue();
                DeploymentDescriptorNode.setAttributeNS(node, prefix, namespaceURI);
            }
        }
    }

    @Override
    public void addPrefixMapping(String prefix, String uri) {
        T descriptor = this.getDescriptor();
        if (descriptor != null) {
            descriptor.addPrefixMapping(prefix, uri);
        }
    }

    @Override
    public String resolvePrefix(XMLElement element, String prefix) {
        return element.getPrefixURIMapping(prefix);
    }

    public String getPrefixFromQName(String qname) {
        StringTokenizer tokenizer = new StringTokenizer(qname, QNAME_SEPARATOR);
        return tokenizer.countTokens() == 2 ? tokenizer.nextToken() : "";
    }

    public String getLocalPartFromQName(String qname) {
        StringTokenizer tokenizer = new StringTokenizer(qname, QNAME_SEPARATOR);
        String localPart = qname;
        if (tokenizer.countTokens() == 2) {
            tokenizer.nextToken();
            localPart = tokenizer.nextToken();
        }
        return localPart;
    }

    public String composeQNameValue(String prefix, String localPart) {
        return prefix == null || prefix.isEmpty() ? localPart : prefix + QNAME_SEPARATOR + localPart;
    }

    public void appendQNameChild(String elementName, Node parent, String namespaceUri, String localPart, String prefix) {
        if (prefix == null) {
            prefix = elementName + "_ns__";
        }
        String elementValue = this.composeQNameValue((String)prefix, localPart);
        Element element = (Element)DeploymentDescriptorNode.appendTextChild(parent, elementName, elementValue);
        DeploymentDescriptorNode.setAttributeNS(element, (String)prefix, namespaceUri);
    }

    private Method getCompatibleMethod(Class<?> descriptor, String methodName, Class<?> parameter) {
        Method[] methods;
        LOG.log(System.Logger.Level.DEBUG, "getCompatibleMethod(descriptor={0}, methodName={1}, parameter={2})", descriptor, methodName, parameter);
        try {
            return descriptor.getMethod(methodName, parameter);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Reflection failed - SecurityException", e);
        }
        for (Method method : methods = descriptor.getMethods()) {
            Class<?> parameterOfMethod;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || !method.getName().equals(methodName) || !(parameterOfMethod = parameterTypes[0]).isAssignableFrom(parameter)) continue;
            return method;
        }
        throw new IllegalArgumentException("Reflection failed for descriptor " + String.valueOf(descriptor) + ", it's method named " + methodName + " and parameter " + String.valueOf(parameter));
    }
}

