/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.InjectionTargetNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import org.w3c.dom.Node;

public class EnvEntryNode
extends DeploymentDescriptorNode<EnvironmentProperty> {
    private static final System.Logger LOG = System.getLogger(EnvEntryNode.class.getName());

    public EnvEntryNode() {
        this.registerElementHandler(new XMLElement("injection-target"), InjectionTargetNode.class, "addInjectionTarget");
    }

    @Override
    public EnvironmentProperty createDescriptor() {
        return new EnvironmentProperty();
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("env-entry-name", "setName");
        table.put("env-entry-value", "setValue");
        table.put("env-entry-type", "setType");
        table.put("mapped-name", "setMappedName");
        table.put("lookup-name", "setLookupName");
        return table;
    }

    @Override
    public boolean endElement(XMLElement element) {
        LOG.log(System.Logger.Level.TRACE, "endElement(element={0}); this={1}", element, this);
        if (!((EnvironmentProperty)this.getDescriptor()).getValue().isEmpty() && ((EnvironmentProperty)this.getDescriptor()).hasLookupName()) {
            throw new IllegalArgumentException("Cannot specify both the env-entry-value and lookup-name elements for env-entry element: " + String.valueOf(this.getDescriptor()));
        }
        return super.endElement(element);
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        if (((EnvironmentProperty)this.getDescriptor()).hasContent()) {
            super.addDescriptor(newDescriptor);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, EnvironmentProperty envProp) {
        Node envEntryNode = super.writeDescriptor(parent, nodeName, envProp);
        EnvEntryNode.writeLocalizedDescriptions(envEntryNode, envProp);
        EnvEntryNode.appendTextChild(envEntryNode, "env-entry-name", envProp.getName());
        EnvEntryNode.appendTextChild(envEntryNode, "env-entry-type", envProp.getType());
        EnvEntryNode.appendTextChild(envEntryNode, "env-entry-value", envProp.getValue());
        EnvEntryNode.appendTextChild(envEntryNode, "mapped-name", envProp.getMappedName());
        if (envProp.isInjectable()) {
            InjectionTargetNode ijNode = new InjectionTargetNode();
            for (InjectionTarget target : envProp.getInjectionTargets()) {
                ijNode.writeDescriptor(envEntryNode, "injection-target", target);
            }
        }
        EnvEntryNode.appendTextChild(envEntryNode, "lookup-name", envProp.getLookupName());
        return envEntryNode;
    }
}

