/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.taglibs.standard.lang.jstl;

import org.glassfish.wasp.taglibs.standard.lang.jstl.BinaryOperator;
import org.glassfish.wasp.taglibs.standard.lang.jstl.Coercions;
import org.glassfish.wasp.taglibs.standard.lang.jstl.Constants;
import org.glassfish.wasp.taglibs.standard.lang.jstl.ELException;
import org.glassfish.wasp.taglibs.standard.lang.jstl.Logger;
import org.glassfish.wasp.taglibs.standard.lang.jstl.PrimitiveObjects;

public class IntegerDivideOperator
extends BinaryOperator {
    public static final IntegerDivideOperator SINGLETON = new IntegerDivideOperator();

    @Override
    public String getOperatorSymbol() {
        return "idiv";
    }

    @Override
    public Object apply(Object pLeft, Object pRight, Object pContext, Logger pLogger) throws ELException {
        if (pLeft == null && pRight == null) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning(Constants.ARITH_OP_NULL, this.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        long left = Coercions.coerceToPrimitiveNumber(pLeft, Long.class, pLogger).longValue();
        long right = Coercions.coerceToPrimitiveNumber(pRight, Long.class, pLogger).longValue();
        try {
            return PrimitiveObjects.getLong(left / right);
        }
        catch (Exception exc) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + left), (Object)("" + right));
            }
            return PrimitiveObjects.getInteger(0);
        }
    }
}

