/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;

public class TransformerBasedValueHolder<T>
extends DatabaseValueHolder<T> {
    protected transient AttributeTransformer transformer;
    protected transient Object object;

    public TransformerBasedValueHolder(AttributeTransformer theTransformer, Object theObject, AbstractRecord theRow, AbstractSession theSession) {
        this.row = theRow;
        this.session = theSession;
        if (!this.session.isUnitOfWork()) {
            this.session = this.session.getRootSession(null);
        }
        this.transformer = theTransformer;
        this.object = theObject;
    }

    protected AttributeTransformer getTransformer() {
        return this.transformer;
    }

    protected Object getObject() {
        return this.object;
    }

    @Override
    protected T instantiate() throws DescriptorException {
        return this.instantiate(this.getObject(), this.getSession());
    }

    protected T instantiate(Object object, AbstractSession session) throws DescriptorException {
        try {
            return (T)this.transformer.buildAttributeValue(this.getRow(), object, session);
        }
        catch (DescriptorException ex) {
            Throwable nestedException = ex.getInternalException();
            if (nestedException instanceof IllegalAccessException) {
                throw DescriptorException.illegalAccessWhileInstantiatingMethodBasedProxy(nestedException);
            }
            if (nestedException instanceof IllegalArgumentException) {
                throw DescriptorException.illegalArgumentWhileInstantiatingMethodBasedProxy(nestedException);
            }
            if (nestedException instanceof InvocationTargetException) {
                throw DescriptorException.targetInvocationWhileInstantiatingMethodBasedProxy(nestedException);
            }
            throw ex;
        }
    }

    @Override
    public T instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder<T> unitOfWorkValueHolder) {
        return this.instantiate(this.getObject(), unitOfWorkValueHolder.getUnitOfWork());
    }

    @Override
    public boolean isPessimisticLockingValueHolder() {
        return false;
    }

    protected void setTransformer(AttributeTransformer theTransformer) {
        this.transformer = theTransformer;
    }

    protected void setObject(Object theObject) {
        this.object = theObject;
    }
}

