/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.IdentificationVariableDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class JoinDeclNode
extends IdentificationVariableDeclNode {
    private Node path;
    private boolean outerJoin;

    @Override
    public Node getPath() {
        return this.path;
    }

    public void setPath(Node node) {
        this.path = node;
    }

    public boolean isOuterJoin() {
        return this.outerJoin;
    }

    public void setOuterJoin(boolean outerJoin) {
        this.outerJoin = outerJoin;
    }

    @Override
    public Node qualifyAttributeAccess(ParseTreeContext context) {
        if (this.path != null) {
            this.path = this.path.qualifyAttributeAccess(context);
        }
        return this;
    }

    @Override
    public void validate(ParseTreeContext context) {
        super.validate(context);
        if (this.path != null) {
            this.path.validate(context);
            this.setType(this.path.getType());
            if (this.path.isDotNode()) {
                TypeHelper typeHelper = context.getTypeHelper();
                Node left = this.path.getLeft();
                AttributeNode right = (AttributeNode)this.path.getRight();
                if (left != null && right != null && typeHelper.isEmbeddedAttribute(left.getType(), right.getAttributeName())) {
                    throw JPQLException.unsupportJoinArgument(context.getQueryInfo(), this.getLine(), this.getColumn(), "Join", this.getType().toString());
                }
            }
        }
    }
}

